/*
 * Decompiled with CFR 0.152.
 */
package fr.dutra.tools.maven.deptree.core;

import fr.dutra.tools.maven.deptree.core.Node;
import fr.dutra.tools.maven.deptree.core.Visitor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.output.StringBuilderWriter;

public abstract class AbstractTextVisitor
implements Visitor {
    private final StringBuilderWriter sbw = new StringBuilderWriter();
    private final BufferedWriter bw = new BufferedWriter((Writer)this.sbw);

    @Override
    public void visit(Node node) {
        try {
            this.writeNode(node);
            for (Node child : node.getChildNodes()) {
                this.visit(child);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeNode(Node node) throws IOException {
        this.writeTreeSymbols(node);
        this.bw.write(node.getArtifactCanonicalForm());
        this.bw.newLine();
    }

    private void writeTreeSymbols(Node node) throws IOException {
        if (node.getParent() != null) {
            this.writeParentTreeSymbols(node.getParent());
            this.bw.write(this.getTreeSymbols(node));
        }
    }

    private void writeParentTreeSymbols(Node node) throws IOException {
        if (node.getParent() != null) {
            this.writeParentTreeSymbols(node.getParent());
            this.bw.write(this.getParentTreeSymbols(node));
        }
    }

    public abstract String getTreeSymbols(Node var1);

    public abstract String getParentTreeSymbols(Node var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            this.bw.flush();
            this.sbw.flush();
            String string = this.sbw.toString();
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                this.bw.close();
            }
            catch (IOException iOException) {}
            this.sbw.close();
        }
    }
}

