/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.sast.utils.zip;

import com.cx.restclient.sast.utils.zip.ZipListener;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;

public class NewCxZipFile
implements Closeable {
    private static final double AVERAGE_ZIP_COMPRESSION_RATIO = 4.0;
    private final Logger log;
    private final long maxSize;
    private final ZipListener listener;
    private final OutputStream outputStream;
    private final ZipOutputStream zipOutputStream;
    private long fileCount;
    private long compressedSize;

    public NewCxZipFile(File zipFile, long maxZipSizeInBytes, Logger log) throws IOException {
        this.log = log;
        this.maxSize = maxZipSizeInBytes;
        this.fileCount = 0L;
        this.compressedSize = 0L;
        this.listener = (fileName, size) -> {
            ++this.fileCount;
            if (log.isInfoEnabled()) {
                log.info("Zipping ( {} ): {}", (Object)FileUtils.byteCountToDisplaySize((long)size), (Object)fileName);
            }
        };
        this.outputStream = new FileOutputStream(zipFile);
        this.zipOutputStream = new ZipOutputStream(this.outputStream);
        this.zipOutputStream.setEncoding("UTF8");
    }

    public void zipContentAsFile(String pathInZip, byte[] content) throws IOException {
        this.validateNextFileWillNotReachMaxCompressedSize(content.length);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(content);){
            this.compressedSize += this.InsertZipEntry(this.zipOutputStream, pathInZip, inputStream);
            if (this.listener != null) {
                this.listener.updateProgress(pathInZip, this.compressedSize);
            }
        }
        catch (IOException ioException) {
            this.log.warn(String.format("Failed to add file to archive: %s", pathInZip), (Throwable)ioException);
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((OutputStream)this.zipOutputStream);
        IOUtils.closeQuietly((OutputStream)this.outputStream);
    }

    public void addMultipleFilesToArchive(File baseDir, List<String> relativePaths) throws IOException {
        assert (baseDir != null) : "baseDir must not be null";
        assert (this.outputStream != null) : "outputStream must not be null";
        int len$ = relativePaths.size();
        for (int i$ = 0; i$ < len$; ++i$) {
            String fileName = relativePaths.get(i$);
            File file = new File(baseDir, fileName);
            if (!file.canRead()) {
                this.log.warn("Skipping unreadable file: {}", (Object)file);
                continue;
            }
            this.validateNextFileWillNotReachMaxCompressedSize(file.length());
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                this.compressedSize += this.InsertZipEntry(this.zipOutputStream, fileName, fileInputStream);
                if (this.listener == null) continue;
                this.listener.updateProgress(fileName, this.compressedSize);
                continue;
            }
            catch (IOException ioException) {
                this.log.warn(String.format("Failed to add file to archive: %s", fileName), (Throwable)ioException);
            }
        }
        this.zipOutputStream.flush();
    }

    private void validateNextFileWillNotReachMaxCompressedSize(double uncompressedSize) throws IOException {
        if (this.maxSize > 0L && (double)this.compressedSize + uncompressedSize / 4.0 > (double)this.maxSize) {
            this.log.info("Maximum zip file size reached. Zip size: {} bytes Limit: {} bytes", (Object)this.compressedSize, (Object)this.maxSize);
            throw new MaxZipSizeReached(this.compressedSize, this.maxSize);
        }
    }

    private long InsertZipEntry(ZipOutputStream zipOutputStream, String fileName, InputStream inputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOutputStream.putNextEntry(zipEntry);
        IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
        zipOutputStream.closeEntry();
        return zipEntry.getCompressedSize();
    }

    private DirectoryScanner createDirectoryScanner(File baseDir, String[] filterIncludePatterns, String[] filterExcludePatterns) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(baseDir);
        ds.setCaseSensitive(false);
        ds.setFollowSymlinks(true);
        ds.setErrorOnMissingDir(false);
        if (filterIncludePatterns != null && filterIncludePatterns.length > 0) {
            ds.setIncludes(filterIncludePatterns);
        }
        if (filterExcludePatterns != null && filterExcludePatterns.length > 0) {
            ds.setExcludes(filterExcludePatterns);
        }
        return ds;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public static class MaxZipSizeReached
    extends IOException {
        private long compressedSize;
        private long maxZipSize;

        public MaxZipSizeReached(long compressedSize, long maxZipSize) {
            super("Zip compressed size reached a limit of " + maxZipSize + " bytes");
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public long getMaxZipSize() {
            return this.maxZipSize;
        }
    }
}

