/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.sast.utils;

import com.cx.restclient.common.UrlUtils;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.cxArm.dto.CxArmConfig;
import com.cx.restclient.dto.CxVersion;
import com.cx.restclient.dto.EngineConfiguration;
import com.cx.restclient.dto.LoginSettings;
import com.cx.restclient.dto.Team;
import com.cx.restclient.dto.TokenLoginResponse;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.exception.CxHTTPClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import com.cx.restclient.httpClient.utils.HttpClientHelper;
import com.cx.restclient.osa.dto.ClientType;
import com.cx.restclient.sast.dto.CreateBranchStatus;
import com.cx.restclient.sast.dto.CreateProjectRequest;
import com.cx.restclient.sast.dto.CxID;
import com.cx.restclient.sast.dto.CxNameObj;
import com.cx.restclient.sast.dto.DataRetentionSettingsDto;
import com.cx.restclient.sast.dto.PostAction;
import com.cx.restclient.sast.dto.Preset;
import com.cx.restclient.sast.dto.Project;
import com.cx.restclient.sast.utils.State;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.StringEntity;
import org.json.JSONException;
import org.slf4j.Logger;

public abstract class LegacyClient {
    private static final String DEFAULT_AUTH_API_PATH = "CxRestApi/auth/identity/connect/token";
    public static final String PRESETNAME_PROJET_SETTING_DEFAULT = "Project Default";
    public static final String PRESETID_PROJET_SETTING_DEFAULT = "0";
    private static final Integer UNKNOWN_INT = -1;
    private static final String ID_PATH_PARAM = "{id}";
    protected CxHttpClient httpClient;
    protected CxScanConfig config;
    protected Logger log;
    private String teamPath;
    protected long projectId;
    private State state = State.SUCCESS;
    private boolean isNewProject = false;

    public LegacyClient(CxScanConfig config, Logger log) throws MalformedURLException {
        this.config = config;
        this.log = log;
        this.initHttpClient(config, log);
        this.validateConfig(config);
    }

    public void setConfig(CxScanConfig config) {
        this.config = config;
    }

    public void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public boolean isIsNewProject() {
        return this.isNewProject;
    }

    public void setIsNewProject(boolean isNewProject) {
        this.isNewProject = isNewProject;
    }

    public long resolveProjectId() throws IOException {
        List<Project> projects = this.getProjectByName(this.config.getProjectName(), this.config.getTeamId(), this.teamPath);
        if (projects == null || projects.isEmpty()) {
            if (this.config.getDenyProject().booleanValue()) {
                throw new CxClientException("Creation of the new project [{projectName}] is not authorized. Please use an existing project. \nYou can enable the creation of new projects by disabling the Deny new Checkmarx projects creation checkbox in the Checkmarx plugin global settings.\n".replace("{projectName}", this.config.getProjectName()));
            }
            if (this.config.isEnableSASTBranching().booleanValue()) {
                if (StringUtils.isEmpty((String)this.config.getMasterBranchProjName())) {
                    throw new CxClientException("Master branch project name is must to create branched project.");
                }
                List<Project> masterProject = this.getProjectByName(this.config.getMasterBranchProjName(), this.config.getTeamId(), this.teamPath);
                if (masterProject == null || masterProject.isEmpty()) {
                    throw new CxClientException("Master branch project does not exist:" + this.config.getMasterBranchProjName());
                }
                Long masterProjectId = masterProject.get(0).getId();
                this.log.info("Project not found, creating a new one.: '{}' with Team '{}'", (Object)this.config.getProjectName(), (Object)this.teamPath);
                this.projectId = this.createChildProject(masterProjectId, this.config.getProjectName());
                if (this.projectId == (long)UNKNOWN_INT.intValue()) {
                    throw new CxClientException("Branched project could not be created: " + this.config.getProjectName());
                }
                this.checkCreateBranchProjectStatus(this.projectId);
                this.log.info("Created a project with ID {}", (Object)this.projectId);
                if (this.config.isEnableDataRetention()) {
                    this.setRetentionRate(this.projectId);
                }
                this.setIsNewProject(true);
            } else {
                CreateProjectRequest request = new CreateProjectRequest(this.config.getProjectName(), this.config.getTeamId(), this.config.getPublic());
                this.log.info("Project not found, creating a new one.: '{}' with Team '{}'", (Object)this.config.getProjectName(), (Object)this.teamPath);
                this.projectId = this.createNewProject(request, this.teamPath).getId();
                this.log.info("Created a project with ID {}", (Object)this.projectId);
                if (this.config.isEnableDataRetention()) {
                    this.setRetentionRate(this.projectId);
                }
                this.setIsNewProject(true);
            }
        } else {
            this.projectId = projects.get(0).getId();
            if (this.config.isEnableDataRetention()) {
                this.setRetentionRate(this.projectId);
            }
            this.setIsNewProject(false);
            this.log.info("Project already exists with ID {}", (Object)this.projectId);
        }
        return this.projectId;
    }

    private void checkCreateBranchProjectStatus(long branchprojectId) throws IOException {
        String Status2 = "";
        CreateBranchStatus getBranchRequest = null;
        int timeout = this.checkTimeOut();
        for (int i = 0; i < 3; ++i) {
            try {
                getBranchRequest = this.populateBranchStatusList(branchprojectId);
            }
            catch (Exception e) {
                this.log.info("Version is less than SAST 9.5 V4");
                break;
            }
            if (getBranchRequest == null) continue;
            Status2 = getBranchRequest.getStatus().getValue();
            this.log.info("Interval =" + i + "  BranchStatus=" + Status2);
            if (Status2.equals("Completed")) break;
            this.waitTime(timeout);
        }
    }

    private void waitTime(int timeout) {
        try {
            this.log.info("timeout =" + timeout + " Seconds");
            Thread.sleep(timeout * 1000);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private int checkTimeOut() {
        int timeout = 10;
        if (this.config.getcopyBranchTimeOutInSeconds() != null) {
            timeout = this.config.getcopyBranchTimeOutInSeconds();
            this.log.info("copybranchtimeoutinseconds =" + timeout + " Seconds");
        }
        if (timeout > 0 && timeout < 60) {
            this.log.info("copybranchtimeoutinseconds is " + timeout + "seconds");
        } else {
            timeout = 10;
            this.log.warn("copybranchtimeoutinseconds is not between the range of 0 to 60 seconds, using default timeout i.e. 10 seconds");
        }
        return timeout;
    }

    private CreateBranchStatus populateBranchStatusList(long branchprojectId) throws IOException, CxClientException {
        return this.httpClient.getRequest("projects/branch/{id}".replace(ID_PATH_PARAM, Long.toString(branchprojectId)), "application/json;v=4.0", CreateBranchStatus.class, 200, "branch status", false);
    }

    public String configureTeamPath() throws IOException, CxClientException {
        if (StringUtils.isEmpty((String)this.config.getTeamPath())) {
            List<Team> teamList = this.populateTeamList();
            if (StringUtils.isEmpty((String)this.teamPath) && teamList != null && !teamList.isEmpty()) {
                this.teamPath = teamList.get(0).getFullName();
            }
        } else {
            this.teamPath = this.config.getTeamPath();
        }
        this.httpClient.setTeamPathHeader(this.teamPath);
        this.log.debug(String.format("setTeamPathHeader %s", this.teamPath));
        return this.teamPath;
    }

    public List<Team> getTeamList() throws IOException, CxClientException {
        return this.populateTeamList();
    }

    private List<Team> populateTeamList() throws IOException {
        return (List)((Object)this.httpClient.getRequest("auth/teams", "application/json;v=1.0", Team.class, 200, "team list", true));
    }

    public String getToken() throws IOException, CxClientException {
        LoginSettings settings = this.getDefaultLoginSettings();
        settings.setClientTypeForPasswordAuth(ClientType.CLI);
        TokenLoginResponse tokenLoginResponse = this.getHttpClient().generateToken(settings);
        return tokenLoginResponse.getRefresh_token();
    }

    public void revokeToken(String token) throws IOException, CxClientException {
        this.getHttpClient().revokeToken(token);
    }

    private Project createNewProject(CreateProjectRequest request, String teamPath) throws IOException {
        String json = HttpClientHelper.convertToJson(request);
        this.httpClient.setTeamPathHeader(teamPath);
        StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
        return this.httpClient.postRequest("projects", "application/json;v=1.0", (HttpEntity)entity, Project.class, 201, "create new project: " + request.getName());
    }

    private List<Project> getProjectByName(String projectName, String teamId, String teamPath) throws IOException, CxClientException {
        List projects;
        block2: {
            projectName = URLEncoder.encode(projectName, "UTF-8");
            String projectNamePath = "projects?projectname={name}&teamid={teamId}".replace("{name}", projectName).replace("{teamId}", teamId);
            projects = null;
            try {
                this.httpClient.setTeamPathHeader(teamPath);
                projects = (List)((Object)this.httpClient.getRequest(projectNamePath, "application/json;v=1.0", Project.class, 200, "project by name: " + projectName, true));
            }
            catch (CxHTTPClientException ex) {
                if (ex.getStatusCode() == 404) break block2;
                throw ex;
            }
        }
        return projects;
    }

    private void initHttpClient(CxScanConfig config, Logger log) throws MalformedURLException {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)config.getUrl())) {
            this.httpClient = new CxHttpClient(UrlUtils.parseURLToString(config.getUrl(), "CxRestAPI/"), config.getCxOrigin(), config.getCxOriginUrl(), config.isDisableCertificateValidation(), config.isUseSSOLogin(), config.getRefreshToken(), config.isProxy(), config.getProxyConfig(), log, config.getNTLM(), config.getPluginVersion());
        }
    }

    public void initiate() throws CxClientException {
        try {
            if (this.config.isSastOrOSAEnabled()) {
                String version = this.getCxVersion();
                this.login(version);
                this.resolveTeam();
                if (this.config.isSastEnabled()) {
                    this.resolvePreset();
                }
                if (this.config.getEnablePolicyViolations() || this.config.getEnablePolicyViolationsSCA()) {
                    this.resolveCxARMUrl();
                }
                this.resolveEngineConfiguration();
                this.resolveProjectId();
                this.resolvePostScanAction();
            }
        }
        catch (Exception e) {
            throw new CxClientException(e);
        }
    }

    public String getCxVersion() throws IOException, CxClientException {
        String version;
        try {
            this.config.setCxVersion(this.httpClient.getRequest("system/version", "application/json;v=1.1", CxVersion.class, 200, "cx Version", false));
            String hotfix = "";
            try {
                if (this.config.getCxVersion().getHotFix() != null && Integer.parseInt(this.config.getCxVersion().getHotFix()) > 0) {
                    hotfix = " Hotfix [" + this.config.getCxVersion().getHotFix() + "].";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            version = this.config.getCxVersion().getVersion();
            this.log.info("Checkmarx server version [" + this.config.getCxVersion().getVersion() + "]." + hotfix);
            this.log.info("Checkmarx Engine Pack Version [" + this.config.getCxVersion().getEnginePackVersion() + "].");
        }
        catch (Exception ex) {
            version = "lower than 9.0";
            this.log.debug("Checkmarx server version [lower than 9.0]");
        }
        return version;
    }

    public String login(Boolean isVersionRequired) throws IOException {
        String cxVersion = this.getCxVersion();
        this.login(cxVersion);
        return cxVersion;
    }

    public void login() throws IOException {
        String version = this.getCxVersion();
        this.login(version);
    }

    public void login(String version) throws IOException, CxClientException {
        this.log.info("Logging into the Checkmarx service.");
        if (this.config.getToken() != null) {
            this.httpClient.setToken(this.config.getToken());
            return;
        }
        LoginSettings settings = this.getDefaultLoginSettings();
        settings.setRefreshToken(this.config.getRefreshToken());
        settings.setVersion(version);
        this.httpClient.login(settings);
    }

    public LoginSettings getDefaultLoginSettings() throws MalformedURLException {
        String baseUrl = UrlUtils.parseURLToString(this.config.getUrl(), DEFAULT_AUTH_API_PATH);
        LoginSettings result = LoginSettings.builder().accessControlBaseUrl(baseUrl).username(this.config.getUsername()).password(this.config.getPassword()).clientTypeForPasswordAuth(ClientType.RESOURCE_OWNER).clientTypeForRefreshToken(ClientType.CLI).build();
        result.getSessionCookies().addAll(this.config.getSessionCookie());
        return result;
    }

    public CxHttpClient getHttpClient() {
        return this.httpClient;
    }

    private void resolveEngineConfiguration() throws IOException {
        if (this.config.getEngineConfigurationId() == null && this.config.getEngineConfigurationName() == null) {
            this.config.setEngineConfigurationId(1);
        } else if (this.config.getEngineConfigurationName() != null) {
            List<EngineConfiguration> engineConfigurations = this.getEngineConfiguration();
            for (EngineConfiguration engineConfiguration : engineConfigurations) {
                if (engineConfiguration.getName().equalsIgnoreCase(this.config.getEngineConfigurationName())) {
                    this.config.setEngineConfigurationId(engineConfiguration.getId());
                    this.log.info(String.format("Engine configuration: \"%s\" was validated in server", this.config.getEngineConfigurationName()));
                    continue;
                }
                if (!"Improved Scan Flow".equalsIgnoreCase(this.config.getEngineConfigurationName())) continue;
                this.config.setEngineConfigurationId(1);
            }
            if (this.config.getEngineConfigurationId() == null) {
                throw new CxClientException("Engine configuration: \"" + this.config.getEngineConfigurationName() + "\" was not found in server");
            }
        }
    }

    public List<EngineConfiguration> getEngineConfiguration() throws IOException {
        this.teamPath = this.configureTeamPath();
        this.httpClient.setTeamPathHeader(this.teamPath);
        return (List)((Object)this.httpClient.getRequest("sast/engineConfigurations", "application/json;v=1.0", EngineConfiguration.class, 200, "engine configurations", true));
    }

    public void validateConfig(CxScanConfig config) throws CxClientException {
        String message = null;
        if (config == null) {
            message = "Non-null config must be provided.";
        } else if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)config.getUrl()) && config.isSastOrOSAEnabled()) {
            message = "Server URL is required when SAST or OSA is enabled.";
        }
        if (message != null) {
            throw new CxClientException(message);
        }
    }

    private void resolveTeam() throws CxClientException, IOException {
        this.config.setTeamPath(this.configureTeamPath());
        if (this.config.getTeamId() == null) {
            this.config.setTeamId(this.getTeamIdByName(this.config.getTeamPath()));
        }
        this.printTeamPath();
    }

    public String getTeamIdByName(String teamName) throws CxClientException, IOException {
        teamName = this.replaceDelimiters(teamName);
        List<Team> allTeams = this.getTeamList();
        for (Team team : allTeams) {
            String fullName = this.replaceDelimiters(team.getFullName());
            if (!fullName.equalsIgnoreCase(teamName)) continue;
            return team.getId();
        }
        throw new CxClientException("Could not resolve team ID from team name: " + teamName);
    }

    private String replaceDelimiters(String teamName) {
        while (teamName.contains("\\") || teamName.contains("//")) {
            teamName = teamName.replace("\\", "/");
            teamName = teamName.replace("//", "/");
        }
        return teamName;
    }

    private CxArmConfig getCxARMConfig() throws IOException, CxClientException {
        this.httpClient.setTeamPathHeader(this.teamPath);
        return this.httpClient.getRequest("/Configurations/Portal", "application/json;v=1.0", CxArmConfig.class, 200, "CxARM URL", false);
    }

    private void resolveCxARMUrl() throws CxClientException {
        try {
            this.config.setCxARMUrl(this.getCxARMConfig().getCxARMPolicyURL());
        }
        catch (Exception ex) {
            throw new CxClientException("CxARM is not available. Policy violations cannot be calculated: " + ex.getMessage());
        }
    }

    private void resolvePreset() throws CxClientException, IOException {
        if (this.config.getPresetId() == null && !StringUtils.isEmpty((String)this.config.getPresetName())) {
            if (PRESETNAME_PROJET_SETTING_DEFAULT.equalsIgnoreCase(this.config.getPresetName())) {
                this.config.setPresetId(Integer.parseInt(PRESETID_PROJET_SETTING_DEFAULT));
            } else {
                this.config.setPresetId(this.getPresetIdByName(this.config.getPresetName()));
            }
        } else if (this.config.getPresetId() == Integer.parseInt(PRESETID_PROJET_SETTING_DEFAULT)) {
            this.config.setPresetName(PRESETNAME_PROJET_SETTING_DEFAULT);
        } else {
            this.config.setPresetName(this.getPresetById(this.config.getPresetId()).getName());
        }
        this.log.info(String.format("preset name: %s preset id: %s", this.config.getPresetName(), this.config.getPresetId()));
    }

    private void resolvePostScanAction() throws CxClientException, IOException {
        if (this.config.getPostScanActionId() == null && !StringUtils.isEmpty((String)this.config.getPostScanName())) {
            this.config.setPostScanActionId(this.getPostScanActionIdByName(this.config.getPostScanName()));
            this.log.info(String.format("post scan action name: %s post scan action id: %s", this.config.getPostScanName(), this.config.getPostScanActionId()));
        }
    }

    public int getPresetIdByName(String presetName) throws CxClientException, IOException {
        List<Preset> allPresets = this.getPresetList();
        for (Preset preset : allPresets) {
            if (!preset.getName().equalsIgnoreCase(presetName)) continue;
            return preset.getId();
        }
        throw new CxClientException("Could not resolve preset ID from preset name: " + presetName);
    }

    public List<Preset> getPresetList() throws IOException, CxClientException {
        this.configureTeamPath();
        return (List)((Object)this.httpClient.getRequest("sast/presets", "application/json;v=1.0", Preset.class, 200, "preset list", true));
    }

    public Preset getPresetById(int presetId) throws IOException, CxClientException {
        this.httpClient.setTeamPathHeader(this.teamPath);
        return this.httpClient.getRequest("sast/presets/" + presetId, "application/json;v=1.0", Preset.class, 200, "preset by id", false);
    }

    public List<PostAction> getPostScanActionList() throws IOException, CxClientException {
        this.configureTeamPath();
        return (List)((Object)this.httpClient.getRequest("customTasks", "application/json;v=1.0", PostAction.class, 200, "post scan action list", true));
    }

    public int getPostScanActionIdByName(String name) throws CxClientException, IOException {
        List<PostAction> allPostActionItems = this.getPostScanActionList();
        for (PostAction postAction : allPostActionItems) {
            if (!postAction.getName().equalsIgnoreCase(name)) continue;
            return postAction.getId();
        }
        throw new CxClientException("Could not resolve post scan item ID from post scan action list: " + name);
    }

    private void printTeamPath() {
        try {
            this.teamPath = this.config.getTeamPath();
            if (this.teamPath == null) {
                this.teamPath = this.getTeamNameById(this.config.getTeamId());
            }
            this.log.info(String.format("full team path: %s", this.teamPath));
        }
        catch (Exception e) {
            this.log.warn("Error getting team path.");
        }
    }

    private void setRetentionRate(long projectId) throws IOException {
        DataRetentionSettingsDto retentionRequest = new DataRetentionSettingsDto(this.config.getProjectRetentionRate());
        this.log.info("Sending request to set retentionRate for project with id {}", (Object)projectId);
        String json = HttpClientHelper.convertToJson(retentionRequest);
        this.httpClient.setTeamPathHeader(this.teamPath);
        StringEntity entity = new StringEntity(json);
        try {
            this.httpClient.postRequest("projects/{id}/dataRetentionSettings".replace(ID_PATH_PARAM, Long.toString(projectId)), "application/json;v=1.0", (HttpEntity)entity, CxID.class, 204, "Set retention Rate for project");
            this.log.info("Set '{}' Retention Rate for project with project ID : '{}' ", (Object)this.config.getProjectRetentionRate(), (Object)projectId);
        }
        catch (CxHTTPClientException exception) {
            this.log.info(exception.getMessage());
            this.log.info("Fail to set  Retention Rate for project with project ID {}", (Object)projectId);
        }
    }

    public String getTeamNameById(String teamId) throws CxClientException, IOException {
        List<Team> allTeams = this.getTeamList();
        for (Team team : allTeams) {
            if (!teamId.equals(team.getId())) continue;
            return team.getFullName();
        }
        throw new CxClientException("Could not resolve team name from id: " + teamId);
    }

    public List<Project> getAllProjects() throws IOException, CxClientException {
        List projects;
        block2: {
            projects = null;
            this.configureTeamPath();
            try {
                projects = (List)((Object)this.httpClient.getRequest("projects", "application/json;v=1.0", Project.class, 200, "all projects", true));
            }
            catch (HttpResponseException ex) {
                if (ex.getStatusCode() == 404) break block2;
                throw ex;
            }
        }
        return projects;
    }

    public Project getProjectById(String projectId, String contentType) throws IOException, CxClientException {
        Project projects;
        block2: {
            String projectNamePath = "projects/{projectId}".replace("{projectId}", projectId);
            projects = null;
            try {
                this.httpClient.setTeamPathHeader(this.teamPath);
                projects = this.httpClient.getRequest(projectNamePath, contentType, Project.class, 200, "project by id: " + projectId, false);
            }
            catch (CxHTTPClientException ex) {
                if (ex.getStatusCode() == 404) break block2;
                throw ex;
            }
        }
        return projects;
    }

    public List<CxNameObj> getConfigurationSetList() throws IOException, CxClientException {
        this.configureTeamPath();
        return (List)((Object)this.httpClient.getRequest("sast/engineConfigurations", "application/json;v=1.0", CxNameObj.class, 200, "engine configurations", true));
    }

    public String getTeamPath() {
        return this.teamPath;
    }

    public void setTeamPath(String teamPath) {
        this.teamPath = teamPath;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public long createChildProject(long projectId, String childProjectName) throws IOException, CxClientException {
        long childProjectId = UNKNOWN_INT.intValue();
        CreateProjectRequest request = new CreateProjectRequest(childProjectName);
        String json = HttpClientHelper.convertToJson(request);
        this.httpClient.setTeamPathHeader(this.teamPath);
        StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
        this.log.info("Creating branched project with name '{}' from existing project with ID {}", (Object)childProjectName, (Object)projectId);
        try {
            Project obj = this.httpClient.postRequest("projects/{id}/branch".replace(ID_PATH_PARAM, Long.toString(projectId)), "application/json;v=1.0", (HttpEntity)entity, Project.class, 201, "branch project");
            if (obj != null) {
                childProjectId = obj.getId();
                return childProjectId;
            }
            this.log.error("CX Response for branch project request with name '{}' from existing project with ID {} was null", (Object)childProjectName, (Object)projectId);
        }
        catch (CxHTTPClientException e) {
            this.log.error(e.getMessage());
            this.log.error("Error occured while creating branched project with name '{}' from existing project with ID {}", (Object)childProjectName, (Object)projectId);
        }
        catch (JSONException e) {
            this.log.error("Error processing JSON Response while creating branched project with name '{}' from existing project with ID {}", (Object)childProjectName, (Object)projectId);
            this.log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return childProjectId;
    }
}

