/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.sast.dto;

import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.cxArm.dto.Policy;
import com.cx.restclient.cxArm.utils.CxARMUtils;
import com.cx.restclient.dto.Results;
import com.cx.restclient.sast.dto.CxXMLResults;
import com.cx.restclient.sast.dto.SASTStatisticsResponse;
import com.cx.restclient.sast.dto.SupportedLanguage;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SASTResults
extends Results
implements Serializable {
    private long scanId;
    private static final String DEFAULT_AUTH_API_PATH = "CxRestApi/auth/identity/connect/token";
    private boolean sastResultsReady = false;
    private int high = 0;
    private int critical = 0;
    private int medium = 0;
    private int low = 0;
    private int information = 0;
    private int newCritical = 0;
    private int newHigh = 0;
    private int newMedium = 0;
    private int newLow = 0;
    private int newInfo = 0;
    private String sastScanLink;
    private String sastProjectLink;
    private String sastPDFLink;
    private String scanStart = "";
    private String scanTime = "";
    private String scanStartTime = "";
    private String scanEndTime = "";
    private String sastLanguage = "en-US";
    private Map<String, String> languageMap;
    private String filesScanned;
    private String LOC;
    private List<CxXMLResults.Query> queryList;
    private byte[] rawXMLReport;
    private byte[] PDFReport;
    private String pdfFileName;
    private List<Policy> sastPolicies = new ArrayList<Policy>();

    public Map<String, String> getLanguageMap() {
        return this.languageMap;
    }

    public void setLanguageMap(Map<String, String> languageMap) {
        this.languageMap = languageMap;
    }

    public String getSastLanguage() {
        return this.sastLanguage;
    }

    public void setSastLanguage(String sastLanguage) {
        this.sastLanguage = sastLanguage;
    }

    public void setScanDetailedReport(CxXMLResults reportObj, CxScanConfig config) throws IOException {
        this.setLanguageEquivalent(this.sastLanguage);
        this.scanStart = reportObj.getScanStart();
        this.scanTime = reportObj.getScanTime();
        this.setScanStartEndDates(this.scanStart, this.scanTime, this.sastLanguage);
        this.LOC = reportObj.getLinesOfCodeScanned();
        this.filesScanned = reportObj.getFilesScanned();
        for (CxXMLResults.Query q : reportObj.getQuery()) {
            List<CxXMLResults.Query.Result> qResult = q.getResult();
            block8: for (int i = 0; i < qResult.size(); ++i) {
                CxXMLResults.Query.Result result = qResult.get(i);
                if ("True".equals(result.getFalsePositive())) {
                    qResult.remove(i);
                    continue;
                }
                if (!"New".equals(result.getStatus())) continue;
                Severity sev = Severity.valueOf(result.getSeverity());
                switch (sev) {
                    case Critical: {
                        ++this.newCritical;
                        continue block8;
                    }
                    case High: {
                        ++this.newHigh;
                        continue block8;
                    }
                    case Medium: {
                        ++this.newMedium;
                        continue block8;
                    }
                    case Low: {
                        ++this.newLow;
                        continue block8;
                    }
                    case Information: {
                        ++this.newInfo;
                    }
                }
            }
        }
        this.queryList = reportObj.getQuery();
    }

    private void setLanguageEquivalent(String sastLanguage) {
        if (sastLanguage != null) {
            Locale l = Locale.forLanguageTag(sastLanguage);
            String languageTag = StringUtils.upperCase((String)(l.getLanguage() + l.getCountry()));
            this.languageMap = new HashMap<String, String>();
            SupportedLanguage lang = SupportedLanguage.valueOf(languageTag);
            this.languageMap.put("Critical", lang.getCritical());
            this.languageMap.put("High", lang.getHigh());
            this.languageMap.put("Medium", lang.getMedium());
            this.languageMap.put("Low", lang.getLow());
        }
    }

    public String encodeXSS(String injection) {
        String lt = "<";
        String gt = ">";
        String ap = "'";
        String ic = "\"";
        injection = injection.replace(lt, "&lt;").replace(gt, "&gt;").replace(ap, "&#39;").replace(ic, "&#34;");
        return injection;
    }

    public void setResults(long scanId, SASTStatisticsResponse statisticsResults, String url, long projectId) {
        this.setScanId(scanId);
        this.setCritical(statisticsResults.getCriticalSeverity());
        this.setHigh(statisticsResults.getHighSeverity());
        this.setMedium(statisticsResults.getMediumSeverity());
        this.setLow(statisticsResults.getLowSeverity());
        this.setCritical(statisticsResults.getCriticalSeverity());
        this.setInformation(statisticsResults.getInfoSeverity());
        this.setSastScanLink(url, scanId, projectId);
        this.setSastProjectLink(url, projectId);
    }

    public void addPolicy(Policy policy) {
        this.sastPolicies.addAll(CxARMUtils.getPolicyList(policy));
    }

    public long getScanId() {
        return this.scanId;
    }

    public void setScanId(long scanId) {
        this.scanId = scanId;
    }

    public int getCritical() {
        return this.critical;
    }

    public void setCritical(int critical) {
        this.critical = critical;
    }

    public int getHigh() {
        return this.high;
    }

    public void setHigh(int high) {
        this.high = high;
    }

    public int getMedium() {
        return this.medium;
    }

    public void setMedium(int medium) {
        this.medium = medium;
    }

    public int getLow() {
        return this.low;
    }

    public void setLow(int low) {
        this.low = low;
    }

    public int getInformation() {
        return this.information;
    }

    public void setInformation(int information) {
        this.information = information;
    }

    public int getNewCritical() {
        return this.newCritical;
    }

    public void setNewCritical(int newCritical) {
        this.newCritical = newCritical;
    }

    public int getNewHigh() {
        return this.newHigh;
    }

    public void setNewHigh(int newHigh) {
        this.newHigh = newHigh;
    }

    public int getNewMedium() {
        return this.newMedium;
    }

    public void setNewMedium(int newMedium) {
        this.newMedium = newMedium;
    }

    public int getNewLow() {
        return this.newLow;
    }

    public void setNewLow(int newLow) {
        this.newLow = newLow;
    }

    public int getNewInfo() {
        return this.newInfo;
    }

    public void setNewInfo(int newInfo) {
        this.newInfo = newInfo;
    }

    public String getSastScanLink() {
        return this.sastScanLink;
    }

    public void setSastScanLink(String sastScanLink) {
        this.sastScanLink = sastScanLink;
    }

    public void setSastScanLink(String url, long scanId, long projectId) {
        this.sastScanLink = String.format(url + "/CxWebClient/ViewerMain.aspx?scanId=%s&ProjectID=%s", scanId, projectId);
    }

    public String getSastProjectLink() {
        return this.sastProjectLink;
    }

    public void setSastProjectLink(String sastProjectLink) {
        this.sastProjectLink = sastProjectLink;
    }

    public void setSastProjectLink(String url, long projectId) {
        this.sastProjectLink = String.format(url + "/CxWebClient/portal#/projectState/%d/Summary", projectId);
    }

    public String getSastPDFLink() {
        return this.sastPDFLink;
    }

    public void setSastPDFLink(String sastPDFLink) {
        this.sastPDFLink = sastPDFLink;
    }

    public String getScanStart() {
        return this.scanStart;
    }

    public void setScanStart(String scanStart) {
        this.scanStart = scanStart;
    }

    public String getScanTime() {
        return this.scanTime;
    }

    public void setScanTime(String scanTime) {
        this.scanTime = scanTime;
    }

    public String getScanStartTime() {
        return this.scanStartTime;
    }

    public void setScanStartTime(String scanStartTime) {
        this.scanStartTime = scanStartTime;
    }

    public String getScanEndTime() {
        return this.scanEndTime;
    }

    public void setScanEndTime(String scanEndTime) {
        this.scanEndTime = scanEndTime;
    }

    public String getFilesScanned() {
        return this.filesScanned;
    }

    public void setFilesScanned(String filesScanned) {
        this.filesScanned = filesScanned;
    }

    public boolean isSastResultsReady() {
        return this.sastResultsReady;
    }

    public void setSastResultsReady(boolean sastResultsReady) {
        this.sastResultsReady = sastResultsReady;
    }

    public String getLOC() {
        return this.LOC;
    }

    public void setLOC(String LOC) {
        this.LOC = LOC;
    }

    public void setQueryList(List<CxXMLResults.Query> queryList) {
        this.queryList = queryList;
    }

    public List<CxXMLResults.Query> getQueryList() {
        return this.queryList;
    }

    public byte[] getRawXMLReport() {
        return this.rawXMLReport;
    }

    public String getPdfFileName() {
        return this.pdfFileName;
    }

    public void setPdfFileName(String pdfFileName) {
        this.pdfFileName = pdfFileName;
    }

    public void setRawXMLReport(byte[] rawXMLReport) {
        this.rawXMLReport = rawXMLReport;
    }

    public byte[] getPDFReport() {
        return this.PDFReport;
    }

    public void setPDFReport(byte[] PDFReport) {
        this.PDFReport = PDFReport;
    }

    public boolean hasNewResults() {
        return this.newCritical + this.newHigh + this.newMedium + this.newLow > 0;
    }

    private void setScanStartEndDates(String scanStart, String scanTime, String lang) {
        try {
            LocalDateTime scanStartDate = this.createStartDate(scanStart, lang);
            LocalTime scanTimeDate = this.createTimeDate(scanTime);
            LocalDateTime scanEndDate = this.createEndDate(scanStartDate, scanTimeDate);
            String scanStartDateFormatted = this.formatToDisplayDate(scanStartDate);
            String scanEndDateFormatted = this.formatToDisplayDate(scanEndDate);
            this.scanStartTime = scanStartDateFormatted;
            this.scanEndTime = scanEndDateFormatted;
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }

    private String formatToDisplayDate(LocalDateTime date) throws ParseException {
        String displayDatePattern = "dd/MM/yy HH:mm:ss";
        return date.format(DateTimeFormatter.ofPattern(displayDatePattern));
    }

    private LocalDateTime createStartDate(String scanStart, String langTag) throws Exception {
        LocalDateTime startDate = LocalDateTime.now();
        Locale l = Locale.forLanguageTag(langTag);
        try {
            String languageTag = StringUtils.upperCase((String)(l.getLanguage() + l.getCountry()));
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(SupportedLanguage.valueOf(languageTag).getDatePattern()).toFormatter(l);
            startDate = LocalDateTime.parse(scanStart, formatter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return startDate;
    }

    private LocalTime createTimeDate(String hhmmss) throws ParseException {
        LocalTime scanTime = LocalTime.parse(hhmmss, DateTimeFormatter.ofPattern("HH'h':mm'm':ss's'"));
        return scanTime;
    }

    private LocalDateTime createEndDate(LocalDateTime scanStartDate, LocalTime scanTime) {
        return scanStartDate.plusHours(scanTime.getHour()).plusMinutes(scanTime.getMinute()).plusSeconds(scanTime.getSecond());
    }

    public List<Policy> getSastPolicies() {
        return this.sastPolicies;
    }

    public void setSastPolicies(List<Policy> sastPolicies) {
        this.sastPolicies = sastPolicies;
    }

    public static enum Severity {
        Critical,
        High,
        Medium,
        Low,
        Information;

    }
}

