/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.osa.dto;

import com.cx.restclient.common.ShragaUtils;
import com.cx.restclient.cxArm.dto.Policy;
import com.cx.restclient.cxArm.utils.CxARMUtils;
import com.cx.restclient.dto.Results;
import com.cx.restclient.osa.dto.CVE;
import com.cx.restclient.osa.dto.CVEReportTableRow;
import com.cx.restclient.osa.dto.Library;
import com.cx.restclient.osa.dto.OSAScanStatus;
import com.cx.restclient.osa.dto.OSASummaryResults;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OSAResults
extends Results
implements Serializable {
    private String osaScanId;
    private OSASummaryResults results;
    private List<Library> osaLibraries;
    private List<CVE> osaVulnerabilities;
    private OSAScanStatus osaScanStatus;
    private String osaProjectSummaryLink;
    private boolean osaResultsReady = false;
    private List<CVEReportTableRow> osaCriticalCVEReportTable = new ArrayList<CVEReportTableRow>();
    private List<CVEReportTableRow> osaHighCVEReportTable = new ArrayList<CVEReportTableRow>();
    private List<CVEReportTableRow> osaMediumCVEReportTable = new ArrayList<CVEReportTableRow>();
    private List<CVEReportTableRow> osaLowCVEReportTable = new ArrayList<CVEReportTableRow>();
    private String scanStartTime;
    private String scanEndTime;
    private List<Policy> osaPolicies = new ArrayList<Policy>();

    public OSAResults() {
    }

    public OSAResults(String osaScanId) {
        this.osaScanId = osaScanId;
    }

    public void setResults(OSASummaryResults osaSummaryResults, List<Library> osaLibraries, List<CVE> osaVulnerabilities, OSAScanStatus osaScanStatus, String url, long projectId) {
        this.setResults(osaSummaryResults);
        this.setOsaLibraries(osaLibraries);
        this.setOsaVulnerabilities(osaVulnerabilities);
        this.setOsaCVEReportTable(osaVulnerabilities, osaLibraries);
        this.setDates(osaScanStatus);
        this.setOsaScanStatus(osaScanStatus);
        this.setOsaProjectSummaryLink(url, projectId);
        this.setOsaResultsReady(true);
    }

    public List<Library> getOsaLibraries() {
        return this.osaLibraries;
    }

    public void setOsaLibraries(List<Library> osaLibraries) {
        this.osaLibraries = osaLibraries;
    }

    public List<CVE> getOsaVulnerabilities() {
        return this.osaVulnerabilities;
    }

    public void setOsaVulnerabilities(List<CVE> osaVulnerabilities) {
        this.osaVulnerabilities = osaVulnerabilities;
    }

    public OSASummaryResults getResults() {
        return this.results;
    }

    public void setResults(OSASummaryResults results) {
        this.results = results;
    }

    public OSAScanStatus getOsaScanStatus() {
        return this.osaScanStatus;
    }

    public void setOsaScanStatus(OSAScanStatus osaScanStatus) {
        this.osaScanStatus = osaScanStatus;
    }

    public String getOsaProjectSummaryLink() {
        return this.osaProjectSummaryLink;
    }

    public void setOsaProjectSummaryLink(String osaProjectSummaryLink) {
        this.osaProjectSummaryLink = osaProjectSummaryLink;
    }

    public void setOsaProjectSummaryLink(String url, long projectId) {
        this.osaProjectSummaryLink = String.format(url + "/CxWebClient/SPA/#/viewer/project/%s", projectId);
    }

    public boolean isOsaResultsReady() {
        return this.osaResultsReady;
    }

    public void setOsaResultsReady(boolean osaResultsReady) {
        this.osaResultsReady = osaResultsReady;
    }

    public String getOsaScanId() {
        return this.osaScanId;
    }

    public void setOsaScanId(String osaScanId) {
        this.osaScanId = osaScanId;
    }

    public List<CVEReportTableRow> getOsaCriticalCVEReportTable() {
        return this.osaCriticalCVEReportTable;
    }

    public List<CVEReportTableRow> getOsaHighCVEReportTable() {
        return this.osaHighCVEReportTable;
    }

    public List<CVEReportTableRow> getOsaMediumCVEReportTable() {
        return this.osaMediumCVEReportTable;
    }

    public List<CVEReportTableRow> getOsaLowCVEReportTable() {
        return this.osaLowCVEReportTable;
    }

    public String getScanStartTime() {
        return this.scanStartTime;
    }

    public String getScanEndTime() {
        return this.scanEndTime;
    }

    private void setOsaCVEReportTable(List<CVE> osaVulnerabilities, List<Library> osaLibraries) {
        HashMap<String, CVEReportTableRow> cveMap = new HashMap<String, CVEReportTableRow>();
        HashMap<String, Library> libMap = new HashMap<String, Library>();
        for (Library l : osaLibraries) {
            libMap.put(l.getId(), l);
        }
        for (CVE cve : osaVulnerabilities) {
            Library lib = (Library)libMap.get(cve.getLibraryId());
            String publishDate = ShragaUtils.formatDate(cve.getPublishDate(), "yyyy-MM-dd'T'HH:mm:ss", "dd/MM/yy");
            cveMap.put(cve.getCveName() + "," + cve.getLibraryId(), new CVEReportTableRow(cve.getCveName(), cve.getSeverity().getName(), publishDate, lib.getName(), cve.getState().getName()));
        }
        for (CVEReportTableRow row : cveMap.values()) {
            if ("Critical".equals(row.getSeverity())) {
                this.osaCriticalCVEReportTable.add(row);
                continue;
            }
            if ("High".equals(row.getSeverity())) {
                this.osaHighCVEReportTable.add(row);
                continue;
            }
            if ("Medium".equals(row.getSeverity())) {
                this.osaMediumCVEReportTable.add(row);
                continue;
            }
            if (!"Low".equals(row.getSeverity())) continue;
            this.osaLowCVEReportTable.add(row);
        }
    }

    public void setDates(OSAScanStatus status) {
        this.scanStartTime = ShragaUtils.formatDate(status.getStartAnalyzeTime(), "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS", "dd/MM/yy HH:mm");
        this.scanEndTime = ShragaUtils.formatDate(status.getEndAnalyzeTime(), "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS", "dd/MM/yy HH:mm");
    }

    public void setOsaCriticalCVEReportTable(List<CVEReportTableRow> osaCriticalCVEReportTable) {
        this.osaCriticalCVEReportTable = osaCriticalCVEReportTable;
    }

    public void setOsaHighCVEReportTable(List<CVEReportTableRow> osaHighCVEReportTable) {
        this.osaHighCVEReportTable = osaHighCVEReportTable;
    }

    public void setOsaMediumCVEReportTable(List<CVEReportTableRow> osaMediumCVEReportTable) {
        this.osaMediumCVEReportTable = osaMediumCVEReportTable;
    }

    public void setOsaLowCVEReportTable(List<CVEReportTableRow> osaLowCVEReportTable) {
        this.osaLowCVEReportTable = osaLowCVEReportTable;
    }

    public void setScanStartTime(String scanStartTime) {
        this.scanStartTime = scanStartTime;
    }

    public void setScanEndTime(String scanEndTime) {
        this.scanEndTime = scanEndTime;
    }

    public void addPolicy(Policy policy) {
        this.osaPolicies.addAll(CxARMUtils.getPolicyList(policy));
    }

    public List<Policy> getOsaPolicies() {
        return this.osaPolicies;
    }

    public void setOsaPolicies(List<Policy> osaPolicies) {
        this.osaPolicies = osaPolicies;
    }
}

