/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.httpClient;

import com.cx.restclient.dto.CxVersion;
import com.cx.restclient.dto.LoginSettings;
import com.cx.restclient.dto.ProxyConfig;
import com.cx.restclient.dto.TokenLoginResponse;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.exception.CxTokenExpiredException;
import com.cx.restclient.osa.dto.ClientType;
import com.google.gson.Gson;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.win.WindowsCredentialsProvider;
import org.apache.http.impl.auth.win.WindowsNTLMSchemeFactory;
import org.apache.http.impl.auth.win.WindowsNegotiateSchemeFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.json.JSONObject;
import org.slf4j.Logger;

public class CxHttpClient
implements Closeable {
    private static String HTTP_NO_HOST = System.getProperty("http.nonProxyHosts");
    private static String HTTPS_NO_HOST = System.getProperty("https.nonProxyHosts");
    private static final String HTTPS = "https";
    private static final String LOGIN_FAILED_MSG = "Fail to login with windows authentication: ";
    private static final String DEFAULT_GRANT_TYPE = "password";
    private static final String LOCATION_HEADER = "Location";
    private static final String AUTH_MESSAGE = "authenticate";
    private static final String CLIENT_SECRET_PROP = "client_secret";
    public static final String REFRESH_TOKEN_PROP = "refresh_token";
    private static final String PASSWORD_PROP = "password";
    public static final String CLIENT_ID_PROP = "client_id";
    private static final String KEY_USER = "user";
    private static final String KEY_DOMAIN = "domain";
    private HttpClient apacheClient;
    private Logger log;
    private TokenLoginResponse token;
    private String rootUri;
    private final String refreshToken;
    private String cxOrigin;
    private String cxOriginUrl;
    private Boolean useSSo;
    private Boolean useNTLM;
    private LoginSettings lastLoginSettings;
    private String teamPath;
    private CookieStore cookieStore = new BasicCookieStore();
    private HttpClientBuilder cb = HttpClients.custom();
    private final Map<String, String> customHeaders = new HashMap<String, String>();
    private CxVersion cxVersion;
    private String pluginVersion;

    public CxHttpClient(String rootUri, String origin, boolean disableSSLValidation, boolean isSSO, String refreshToken, boolean isProxy, @Nullable ProxyConfig proxyConfig, Logger log, Boolean useNTLM, String pluginVersion) throws CxClientException {
        this.log = log;
        this.rootUri = rootUri;
        this.refreshToken = refreshToken;
        this.cxOrigin = origin;
        this.useSSo = isSSO;
        this.useNTLM = useNTLM;
        this.pluginVersion = pluginVersion;
        this.cb.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build());
        this.setSSLTls("TLSv1.2", log);
        SSLContextBuilder builder = new SSLContextBuilder();
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        PoolingHttpClientConnectionManager cm = null;
        if (disableSSLValidation) {
            try {
                builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register(HTTPS, (Object)sslConnectionSocketFactory).build();
                cm = new PoolingHttpClientConnectionManager(registry);
                cm.setMaxTotal(100);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                log.error(e.getMessage());
            }
            this.cb.setSSLSocketFactory(sslConnectionSocketFactory);
            this.cb.setConnectionManager(cm);
        } else {
            String customTrustStore = System.getProperty("javax.net.ssl.trustStore");
            if (!StringUtils.isEmpty((CharSequence)customTrustStore)) {
                this.log.info("Custom truststore is configured. Ensure that trusted certificate for all CxSAST/CxSCA endpoints are imported. Custom store path: " + customTrustStore);
            }
            this.cb.setConnectionManager((HttpClientConnectionManager)CxHttpClient.getHttpConnectionManager(false));
        }
        this.cb.setConnectionManagerShared(true);
        if (isProxy && !CxHttpClient.setCustomProxy(this.cb, proxyConfig, log)) {
            this.cb.useSystemProperties();
        }
        if (Boolean.TRUE.equals(this.useSSo)) {
            this.cb.setDefaultCredentialsProvider((CredentialsProvider)new WindowsCredentialsProvider((CredentialsProvider)new SystemDefaultCredentialsProvider()));
            this.cb.setDefaultCookieStore(this.cookieStore);
        } else {
            this.cb.setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        }
        this.cb.setDefaultAuthSchemeRegistry(CxHttpClient.getAuthSchemeProviderRegistry());
        if (useNTLM.booleanValue()) {
            this.setNTLMProxy(proxyConfig, this.cb, log);
        } else {
            this.apacheClient = this.cb.build();
        }
    }

    public CxHttpClient(String rootUri, String origin, String originUrl, boolean disableSSLValidation, boolean isSSO, String refreshToken, boolean isProxy, @Nullable ProxyConfig proxyConfig, Logger log, Boolean useNTLM, String pluginVersion) throws CxClientException {
        this(rootUri, origin, disableSSLValidation, isSSO, refreshToken, isProxy, proxyConfig, log, useNTLM, pluginVersion);
        this.cxOriginUrl = originUrl;
    }

    public void setRootUri(String rootUri) {
        this.rootUri = rootUri;
    }

    public String getRootUri() {
        return this.rootUri;
    }

    private void setNTLMProxy(ProxyConfig proxyConfig, HttpClientBuilder cb, Logger log) {
        if (proxyConfig == null || StringUtils.isEmpty((CharSequence)proxyConfig.getHost()) || proxyConfig.getPort() == 0) {
            log.info("Proxy configuration not provided.");
            this.apacheClient = cb.build();
            return;
        }
        log.info("Setting NTLM proxy for Checkmarx http client");
        HttpHost proxy = new HttpHost(proxyConfig.getHost(), proxyConfig.getPort(), "http");
        HashMap<String, String> userDomainMap = CxHttpClient.splitDomainAndTheUserName(proxyConfig.getUsername());
        String user = userDomainMap.get(KEY_USER);
        String domain = userDomainMap.get(KEY_DOMAIN);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        NTCredentials credentials = new NTCredentials(user, proxyConfig.getPassword(), null, domain);
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        this.apacheClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setProxy(proxy).setProxyAuthenticationStrategy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE).setDefaultRequestConfig(RequestConfig.custom().setAuthenticationEnabled(true).setProxyPreferredAuthSchemes(Arrays.asList("NTLM")).build()).build();
    }

    private static HashMap<String, String> splitDomainAndTheUserName(String userName) {
        String[] parts;
        String domain = "";
        String user = "";
        if (userName.contains("\\")) {
            parts = userName.split("[\\\\]");
            if (parts.length == 2) {
                domain = parts[0];
                user = parts[1];
            }
        } else if (userName.contains("/")) {
            parts = userName.split("[/]");
            if (parts.length == 2) {
                domain = parts[0];
                user = parts[1];
            }
        } else if (userName.contains("@") && (parts = userName.split("[@]")).length == 2) {
            user = parts[0];
            domain = parts[1];
        }
        HashMap<String, String> userDomain = new HashMap<String, String>();
        userDomain.put(KEY_USER, user);
        userDomain.put(KEY_DOMAIN, domain);
        return userDomain;
    }

    private static boolean setCustomProxy(HttpClientBuilder cb, ProxyConfig proxyConfig, Logger logi) {
        if (proxyConfig == null || StringUtils.isEmpty((CharSequence)proxyConfig.getHost()) || proxyConfig.getPort() == 0) {
            return false;
        }
        String scheme = proxyConfig.isUseHttps() ? HTTPS : "http";
        HttpHost proxy = new HttpHost(proxyConfig.getHost(), proxyConfig.getPort(), scheme);
        if (StringUtils.isNotEmpty((CharSequence)proxyConfig.getUsername()) && StringUtils.isNotEmpty((CharSequence)proxyConfig.getPassword())) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyConfig.getUsername(), proxyConfig.getPassword());
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(proxy), (Credentials)credentials);
            cb.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        logi.info("Setting proxy for Checkmarx http client");
        cb.setProxy(proxy);
        cb.setRoutePlanner((HttpRoutePlanner)CxHttpClient.getRoutePlanner(proxyConfig, proxy, logi));
        cb.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
        return true;
    }

    private static DefaultProxyRoutePlanner getRoutePlanner(final ProxyConfig proxyConfig, HttpHost proxyHost, final Logger logi) {
        return new DefaultProxyRoutePlanner(proxyHost){

            public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
                String hostname = host.getHostName();
                String noHost = proxyConfig.getNoproxyHosts();
                if (StringUtils.isNotEmpty((CharSequence)noHost)) {
                    String[] hosts;
                    for (String nonHost : hosts = noHost.split("\\|")) {
                        try {
                            if (CxHttpClient.matchNonProxyHostWildCard(hostname, noHost)) {
                                logi.debug("Bypassing proxy as host " + hostname + " is found in the nonProxyHosts");
                                return new HttpRoute(host);
                            }
                        }
                        catch (PatternSyntaxException e) {
                            logi.warn("Wrong nonProxyHost param: " + nonHost);
                        }
                    }
                }
                return super.determineRoute(host, request, context);
            }
        };
    }

    private static boolean matchNonProxyHostWildCard(String sourceHost, String nonProxyHost) {
        if (nonProxyHost.indexOf("*") > -1) {
            nonProxyHost = nonProxyHost.replaceAll("\\.", "\\\\.");
        }
        nonProxyHost = nonProxyHost.replaceAll("\\*", "\\.\\*");
        Pattern p = Pattern.compile(nonProxyHost);
        Matcher m = p.matcher(sourceHost);
        return m.matches();
    }

    private static SSLConnectionSocketFactory getTrustAllSSLSocketFactory() {
        SSLContext sslContext;
        TrustAllStrategy acceptingTrustStrategy = new TrustAllStrategy();
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)acceptingTrustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new CxClientException("Fail to set trust all certificate, 'SSLConnectionSocketFactory'", e);
        }
        return new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
    }

    private static PoolingHttpClientConnectionManager getHttpConnectionManager(boolean disableSSLValidation) {
        SSLConnectionSocketFactory factory = disableSSLValidation ? CxHttpClient.getTrustAllSSLSocketFactory() : new SSLConnectionSocketFactory(SSLContexts.createDefault(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry socketFactoryRegistry = RegistryBuilder.create().register(HTTPS, (Object)factory).register("http", (Object)new PlainConnectionSocketFactory()).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(50);
        connManager.setDefaultMaxPerRoute(5);
        return connManager;
    }

    private static Registry<AuthSchemeProvider> getAuthSchemeProviderRegistry() {
        return RegistryBuilder.create().register("Digest", (Object)new DigestSchemeFactory()).register("Basic", (Object)new BasicSchemeFactory()).register("NTLM", (Object)new WindowsNTLMSchemeFactory(null)).register("Negotiate", (Object)new WindowsNegotiateSchemeFactory(null)).build();
    }

    public void login(LoginSettings settings) throws IOException {
        this.lastLoginSettings = settings;
        if (!settings.getSessionCookies().isEmpty()) {
            this.setSessionCookies(settings.getSessionCookies());
            return;
        }
        if (settings.getRefreshToken() != null) {
            this.token = this.getAccessTokenFromRefreshToken(settings);
        } else if (Boolean.TRUE.equals(this.useSSo)) {
            if (settings.getVersion().equals("lower than 9.0")) {
                this.ssoLegacyLogin();
            } else {
                this.token = this.ssoLogin();
                System.out.printf("Access Token: %s%n", this.token.getAccess_token());
            }
        } else {
            this.token = this.generateToken(settings);
        }
    }

    public ArrayList<Cookie> ssoLegacyLogin() {
        HttpResponse loginResponse = null;
        try {
            HttpUriRequest request = RequestBuilder.post().setUri(this.rootUri + "auth/ssologin").setConfig(RequestConfig.DEFAULT).setEntity((HttpEntity)new StringEntity("", StandardCharsets.UTF_8)).build();
            loginResponse = this.apacheClient.execute(request);
        }
        catch (IOException e) {
            try {
                String message = LOGIN_FAILED_MSG + e.getMessage();
                this.log.error(message);
                throw new CxClientException(message);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(loginResponse);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)loginResponse);
        this.setSessionCookies(this.cookieStore.getCookies());
        return new ArrayList<Cookie>(this.cookieStore.getCookies());
    }

    private void setSessionCookies(List<Cookie> cookies) {
        String cxCookie = null;
        String csrfToken = null;
        for (Cookie cookie : cookies) {
            if (cookie.getName().equals("CXCSRFToken")) {
                csrfToken = cookie.getValue();
            }
            if (!cookie.getName().equals("cxCookie")) continue;
            cxCookie = cookie.getValue();
        }
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("CXCSRFToken", csrfToken));
        headers.add(new BasicHeader("cookie", String.format("CXCSRFToken=%s; cxCookie=%s", csrfToken, cxCookie)));
        System.out.println("CXCSRFToken: " + csrfToken);
        System.out.printf("cookie: CXCSRFToken=%s; cxCookie=%s%n", csrfToken, cxCookie);
        this.apacheClient = this.cb.setDefaultHeaders(headers).build();
    }

    private TokenLoginResponse ssoLogin() {
        String BASE_URL = "/auth/identity/";
        RequestConfig requestConfig = RequestConfig.custom().setRedirectsEnabled(false).setAuthenticationEnabled(true).setCookieSpec("standard").build();
        try {
            HttpUriRequest request = RequestBuilder.post().setUri(this.rootUri + "auth/identity/externalLogin").setConfig(requestConfig).setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString()).setEntity((HttpEntity)this.generateSSOEntity()).build();
            HttpResponse response = this.apacheClient.execute(request);
            String cookies = this.retrieveCookies();
            String redirectURL = response.getHeaders(LOCATION_HEADER)[0].getValue();
            request = RequestBuilder.get().setUri(this.rootUri + "/auth/identity/" + redirectURL).setConfig(requestConfig).setHeader("Cookie", cookies).setHeader("Upgrade-Insecure-Requests", "1").build();
            response = this.apacheClient.execute(request);
            cookies = this.retrieveCookies();
            redirectURL = response.getHeaders(LOCATION_HEADER)[0].getValue();
            redirectURL = this.rootUri + redirectURL.replace("/CxRestAPI/", "");
            request = RequestBuilder.get().setUri(redirectURL).setConfig(requestConfig).setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString()).setHeader("Cookie", cookies).build();
            response = this.apacheClient.execute(request);
            return this.extractToken(response);
        }
        catch (IOException e) {
            throw new CxClientException(LOGIN_FAILED_MSG + e.getMessage());
        }
    }

    private TokenLoginResponse extractToken(HttpResponse response) {
        String redirectURL = response.getHeaders(LOCATION_HEADER)[0].getValue();
        if (!redirectURL.contains("access_token")) {
            throw new CxClientException("Failed retrieving access token from server");
        }
        return (TokenLoginResponse)new Gson().fromJson(this.urlToJson(redirectURL), TokenLoginResponse.class);
    }

    private String urlToJson(String url) {
        url = url.replace("=", "\":\"");
        url = url.replace("&", "\",\"");
        return "{\"" + url + "\"}";
    }

    private String retrieveCookies() {
        List cookieList = this.cookieStore.getCookies();
        StringBuilder builder = new StringBuilder();
        cookieList.forEach(cookie -> builder.append(cookie.getName()).append("=").append(cookie.getValue()).append(";"));
        return builder.toString();
    }

    public TokenLoginResponse generateToken(LoginSettings settings) throws IOException {
        UrlEncodedFormEntity requestEntity = CxHttpClient.getAuthRequest(settings);
        HttpPost post = new HttpPost(settings.getAccessControlBaseUrl());
        try {
            return this.request((HttpRequestBase)post, ContentType.APPLICATION_FORM_URLENCODED.toString(), (HttpEntity)requestEntity, TokenLoginResponse.class, 200, AUTH_MESSAGE, false, false);
        }
        catch (CxClientException e) {
            if (!e.getMessage().contains("invalid_scope")) {
                throw new CxClientException(String.format("Failed to generate access token, failure error was: %s", e.getMessage()), e);
            }
            ClientType.RESOURCE_OWNER.setScopes("sast_rest_api");
            settings.setClientTypeForPasswordAuth(ClientType.RESOURCE_OWNER);
            UrlEncodedFormEntity requestEntityForSecondLoginRetry = CxHttpClient.getAuthRequest(settings);
            HttpPost post_1 = new HttpPost(settings.getAccessControlBaseUrl());
            return this.request((HttpRequestBase)post_1, ContentType.APPLICATION_FORM_URLENCODED.toString(), (HttpEntity)requestEntityForSecondLoginRetry, TokenLoginResponse.class, 200, AUTH_MESSAGE, false, false);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private TokenLoginResponse getAccessTokenFromRefreshToken(LoginSettings settings) throws IOException {
        UrlEncodedFormEntity requestEntity = CxHttpClient.getTokenRefreshingRequest(settings);
        HttpPost post = new HttpPost(settings.getAccessControlBaseUrl());
        try {
            return this.request((HttpRequestBase)post, ContentType.APPLICATION_FORM_URLENCODED.toString(), (HttpEntity)requestEntity, TokenLoginResponse.class, 200, AUTH_MESSAGE, false, false);
        }
        catch (CxClientException e) {
            throw new CxClientException(String.format("Failed to generate access token from refresh token. The error was: %s", e.getMessage()), e);
        }
    }

    public void revokeToken(String token) throws IOException {
        UrlEncodedFormEntity requestEntity = CxHttpClient.getRevocationRequest(ClientType.CLI, token);
        HttpPost post = new HttpPost(this.rootUri + "auth/identity/connect/revocation");
        try {
            this.request((HttpRequestBase)post, ContentType.APPLICATION_FORM_URLENCODED.toString(), (HttpEntity)requestEntity, String.class, 200, "revocation", false, false);
        }
        catch (CxClientException e) {
            throw new CxClientException(String.format("Token revocation failure error was: %s", e.getMessage()), e);
        }
    }

    private static UrlEncodedFormEntity getRevocationRequest(ClientType clientType, String token) {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("token_type_hint", REFRESH_TOKEN_PROP));
        parameters.add(new BasicNameValuePair("token", token));
        parameters.add(new BasicNameValuePair(CLIENT_ID_PROP, clientType.getClientId()));
        parameters.add(new BasicNameValuePair(CLIENT_SECRET_PROP, clientType.getClientSecret()));
        return new UrlEncodedFormEntity(parameters, StandardCharsets.UTF_8);
    }

    private static UrlEncodedFormEntity getAuthRequest(LoginSettings settings) {
        ClientType clientType = settings.getClientTypeForPasswordAuth();
        String grantType = StringUtils.defaultString((String)clientType.getGrantType(), (String)"password");
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("username", settings.getUsername()));
        parameters.add(new BasicNameValuePair("password", settings.getPassword()));
        parameters.add(new BasicNameValuePair("grant_type", grantType));
        parameters.add(new BasicNameValuePair("scope", clientType.getScopes()));
        parameters.add(new BasicNameValuePair(CLIENT_ID_PROP, clientType.getClientId()));
        parameters.add(new BasicNameValuePair(CLIENT_SECRET_PROP, clientType.getClientSecret()));
        if (!StringUtils.isEmpty((CharSequence)settings.getTenant())) {
            String authContext = String.format("Tenant:%s", settings.getTenant());
            parameters.add(new BasicNameValuePair("acr_values", authContext));
        }
        return new UrlEncodedFormEntity(parameters, StandardCharsets.UTF_8);
    }

    private static UrlEncodedFormEntity getTokenRefreshingRequest(LoginSettings settings) throws UnsupportedEncodingException {
        ClientType clientType = settings.getClientTypeForRefreshToken();
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("grant_type", REFRESH_TOKEN_PROP));
        parameters.add(new BasicNameValuePair(CLIENT_ID_PROP, clientType.getClientId()));
        parameters.add(new BasicNameValuePair(CLIENT_SECRET_PROP, clientType.getClientSecret()));
        parameters.add(new BasicNameValuePair(REFRESH_TOKEN_PROP, settings.getRefreshToken()));
        return new UrlEncodedFormEntity(parameters, StandardCharsets.UTF_8.name());
    }

    public <T> T getRequest(String relPath, String contentType, Class<T> responseType, int expectStatus, String failedMsg, boolean isCollection) throws IOException {
        return this.getRequest(this.rootUri, relPath, "application/json", contentType, responseType, expectStatus, failedMsg, isCollection);
    }

    public <T> T getRequest(String rootURL, String relPath, String acceptHeader, String contentType, Class<T> responseType, int expectStatus, String failedMsg, boolean isCollection) throws IOException {
        HttpGet get = new HttpGet(rootURL + relPath);
        get.addHeader("Accept", acceptHeader);
        return this.request((HttpRequestBase)get, contentType, null, responseType, expectStatus, "get " + failedMsg, isCollection, true);
    }

    public <T> T postRequest(String relPath, String contentType, HttpEntity entity, Class<T> responseType, int expectStatus, String failedMsg) throws IOException {
        HttpPost post = new HttpPost(this.rootUri + relPath);
        return this.request((HttpRequestBase)post, contentType, entity, responseType, expectStatus, failedMsg, false, true);
    }

    public <T> T postRequest(String relPath, String contentType, String acceptHeader, HttpEntity entity, Class<T> responseType, int expectStatus, String failedMsg) throws IOException {
        HttpPost post = new HttpPost(this.rootUri + relPath);
        post.addHeader("Accept", acceptHeader);
        return this.request((HttpRequestBase)post, contentType, entity, responseType, expectStatus, failedMsg, false, true);
    }

    public <T> T putRequest(String relPath, String contentType, HttpEntity entity, Class<T> responseType, int expectStatus, String failedMsg) throws IOException {
        HttpPut put = new HttpPut(this.rootUri + relPath);
        return this.request((HttpRequestBase)put, contentType, entity, responseType, expectStatus, failedMsg, false, true);
    }

    public void patchRequest(String relPath, String contentType, HttpEntity entity, int expectStatus, String failedMsg) throws IOException {
        HttpPatch patch = new HttpPatch(this.rootUri + relPath);
        this.request((HttpRequestBase)patch, contentType, entity, null, expectStatus, failedMsg, false, true);
    }

    public void setTeamPathHeader(String teamPath) {
        this.teamPath = teamPath;
    }

    public void addCustomHeader(String name, String value) {
        this.log.debug(String.format("Adding a custom header: %s: %s", name, value));
        this.customHeaders.put(name, value);
    }

    private String getUserAgentValue() {
        if (this.cxOrigin == null) {
            this.log.warn("cxOrigin is null");
            this.cxOrigin = "unknown";
        }
        String version = null;
        version = System.getProperty("CxPluginVersion") != null ? System.getProperty("CxPluginVersion") : (this.pluginVersion != null ? this.pluginVersion : "unknown");
        return "plugin_name=" + this.cxOrigin + ";plugin_version=" + version;
    }

    /*
     * Exception decompiling
     */
    private <T> T request(HttpRequestBase httpMethod, String contentType, HttpEntity entity, Class<T> responseType, int expectStatus, String failedMsg, boolean isCollection, boolean retry) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeHeaders(HttpRequestBase httpMethod) {
        httpMethod.removeHeaders("Content-type");
        httpMethod.removeHeaders("cxOrigin");
        httpMethod.removeHeaders("cxOriginUrl");
        httpMethod.removeHeaders("cxTeamPath");
        httpMethod.removeHeaders("Authorization");
    }

    @Override
    public void close() {
        HttpClientUtils.closeQuietly((HttpClient)this.apacheClient);
    }

    private void setSSLTls(String protocol, Logger log) {
        try {
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(null, null, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.warn(String.format("Failed to set SSL TLS : %s", e.getMessage()));
        }
    }

    private StringEntity generateSSOEntity() {
        String clientId = "cxsast_client";
        String redirectUri = "%2Fcxwebclient%2FauthCallback.html%3F";
        String responseType = "id_token%20token";
        String nonce = "9313f0902ba64e50bc564f5137f35a52";
        String isPrompt = "true";
        String scopes = "sast_api openid sast-permissions access-control-permissions access_control_api management_and_orchestration_api".replace(" ", "%20");
        String providerId = "2";
        String redirectUrl = MessageFormat.format("/CxRestAPI/auth/identity/connect/authorize/callback?client_id={0}&redirect_uri={1}%2Fcxwebclient%2FauthCallback.html%3F&response_type={2}&scope={3}&nonce={4}&prompt={5}", "cxsast_client", this.rootUri, "id_token%20token", scopes, "9313f0902ba64e50bc564f5137f35a52", "true");
        try {
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            urlParameters.add(new BasicNameValuePair("redirectUrl", redirectUrl));
            urlParameters.add(new BasicNameValuePair("providerid", "2"));
            return new UrlEncodedFormEntity(urlParameters, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new CxClientException(e.getMessage());
        }
    }

    public void setToken(TokenLoginResponse token) {
        this.token = token;
    }

    private void logTokenError(HttpRequestBase httpMethod, int statusCode, CxTokenExpiredException ex) {
        String message = String.format("Received status code %d for URL: %s with the message: %s", statusCode, httpMethod.getURI(), ex.getMessage());
        this.log.warn(message);
        this.log.info("Possible reason: access token has expired. Trying to request a new token...");
    }

    public String getLanguageFromAccessToken() {
        String languageForSAST = "en-US";
        try {
            String actToken = this.token.getAccess_token();
            String[] split_string = actToken.split("\\.");
            if (split_string != null && split_string.length > 0) {
                String base64EncodedBody = split_string[1];
                Base64 base64Url = new Base64(true);
                String body = new String(base64Url.decode(base64EncodedBody));
                String tokenToParse = body.replace("\"", "'");
                JSONObject json = new JSONObject(tokenToParse);
                languageForSAST = json.getString("locale");
                this.log.info("Locale used in CxSAST is  " + languageForSAST);
            }
        }
        catch (Exception ex) {
            languageForSAST = "en-US";
        }
        return languageForSAST;
    }
}

