/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.dto;

import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.RemoteSourceTypes;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"type"})
public class RemoteSourceRequest {
    private Credentials credentials;
    private Uri uri;
    private byte[] privateKey;
    private String[] paths;
    private RemoteSourceTypes type;
    private String browseMode;

    public RemoteSourceRequest() {
    }

    public RemoteSourceRequest(CxScanConfig config) {
        this.credentials = new Credentials(config.getRemoteSrcUser(), config.getRemoteSrcPass());
        this.uri = new Uri(config.getRemoteSrcUrl(), config.getRemoteSrcPort());
        this.privateKey = config.getRemoteSrcKeyFile() == null ? new byte[]{} : config.getRemoteSrcKeyFile();
        this.paths = config.getPaths();
        this.type = config.getRemoteType();
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Uri getUri() {
        return this.uri;
    }

    public void setUri(Uri uri) {
        this.uri = uri;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public void setPaths(String[] paths) {
        this.paths = paths;
    }

    public RemoteSourceTypes getType() {
        return this.type;
    }

    public void setType(RemoteSourceTypes type) {
        this.type = type;
    }

    public String getBrowseMode() {
        return this.browseMode;
    }

    public void setBrowseMode(String browseMode) {
        this.browseMode = browseMode;
    }

    public class Uri {
        private String absoluteUrl;
        private int port;

        public Uri(String absoluteUrl, int port) {
            this.absoluteUrl = absoluteUrl;
            this.port = port;
        }

        public String getAbsoluteUrl() {
            return this.absoluteUrl;
        }

        public void setAbsoluteUrl(String absoluteUrl) {
            this.absoluteUrl = absoluteUrl;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }

    public class Credentials {
        private String userName;
        private String password;

        public Credentials(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

