/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.configuration;

import com.cx.restclient.ast.dto.sast.AstSastConfig;
import com.cx.restclient.ast.dto.sca.AstScaConfig;
import com.cx.restclient.dto.CxVersion;
import com.cx.restclient.dto.ProxyConfig;
import com.cx.restclient.dto.RemoteSourceTypes;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.dto.TokenLoginResponse;
import com.cx.restclient.sast.dto.ReportType;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.cookie.Cookie;

public class CxScanConfig
implements Serializable {
    private String cxOrigin;
    private String cxOriginUrl;
    private CxVersion cxVersion;
    private boolean showCriticalLabel = false;
    private Integer projectRetentionRate;
    private boolean enableDataRetention;
    private boolean disableCertificateValidation = false;
    private boolean useSSOLogin = false;
    private String sourceDir;
    private String osaLocationPath;
    private File reportsDir;
    private Map<ReportType, String> reports = new HashMap<ReportType, String>();
    private String username;
    private String password;
    private String refreshToken;
    private String url;
    private String projectName;
    private String teamPath;
    private String mvnPath;
    private String teamId;
    private Boolean denyProject = false;
    private Boolean hideResults = false;
    private Boolean continueBuild = false;
    private Boolean isPublic = true;
    private Boolean forceScan = false;
    private String presetName;
    private Integer presetId;
    private String postScanName;
    private String sastFolderExclusions;
    private String sastFilterPattern;
    private Integer sastScanTimeoutInMinutes;
    private Integer scaScanTimeoutInMinutes;
    private Integer osaScanTimeoutInMinutes;
    private String scanComment;
    private Boolean isIncremental = false;
    private Boolean isSynchronous = false;
    private Boolean sastThresholdsEnabled = false;
    private Boolean sastEnableCriticalSeverity = false;
    private Integer sastCriticalThreshold;
    private Integer sastHighThreshold;
    private Integer sastMediumThreshold;
    private Integer sastLowThreshold;
    private Boolean sastNewResultsThresholdEnabled = false;
    private String sastNewResultsThresholdSeverity;
    private TokenLoginResponse token;
    private Boolean generatePDFReport = false;
    private File zipFile;
    private Integer engineConfigurationId;
    private String engineConfigurationName;
    private String projectCustomFields;
    private boolean ignoreBenignErrors = false;
    private String pluginVersion;
    private String osaFolderExclusions;
    private String osaFilterPattern;
    private String osaArchiveIncludePatterns;
    private Boolean osaGenerateJsonReport = true;
    private Boolean osaRunInstall = false;
    private Boolean osaThresholdsEnabled = false;
    private Boolean osaFailOnError = false;
    private Integer osaCriticalThreshold;
    private Integer osaHighThreshold;
    private Integer osaMediumThreshold;
    private Integer osaLowThreshold;
    private Properties osaFsaConfig;
    private String osaDependenciesJson;
    private Boolean avoidDuplicateProjectScans = false;
    private boolean enablePolicyViolations = false;
    private boolean enablePolicyViolationsSCA = false;
    private Boolean generateXmlReport = true;
    private String cxARMUrl;
    private String[] paths;
    private RemoteSourceTypes remoteType = null;
    private String remoteSrcUser;
    private String remoteSrcPass;
    private String remoteSrcUrl;
    private int remoteSrcPort;
    private byte[] remoteSrcKeyFile;
    private String remoteSrcBranch;
    private String perforceMode;
    private Integer progressInterval;
    private Integer osaProgressInterval;
    private Integer connectionRetries;
    private String osaScanDepth;
    private Integer maxZipSize;
    private String defaultProjectName;
    private String scaJsonReport;
    private AstScaConfig astScaConfig;
    private AstSastConfig astSastConfig;
    private final Set<ScannerType> scannerTypes = new HashSet<ScannerType>();
    private final List<Cookie> sessionCookies = new ArrayList<Cookie>();
    private Boolean isProxy = true;
    private Boolean isScaProxy = false;
    private ProxyConfig proxyConfig;
    private ProxyConfig proxyScaConfig;
    private Boolean useNTLM = false;
    private boolean generateScaReport = false;
    private boolean hasScaReportFormat = false;
    private String scaReportFormat;
    private Integer postScanActionId;
    private String customFields;
    private String projectLevelCustomFields;
    private boolean isOverrideProjectSetting = false;
    private boolean isOverrideRetentionRate = false;
    private Boolean enableSastBranching = false;
    private String masterBranchProjName;
    private Integer copyBranchTimeOutInSeconds;

    public boolean isShowCriticalLabel() {
        return this.showCriticalLabel;
    }

    public void setShowCriticalLabel(boolean showCriticalLabel) {
        this.showCriticalLabel = showCriticalLabel;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public String getEngineConfigurationName() {
        return this.engineConfigurationName;
    }

    public void setEngineConfigurationName(String engineConfigurationName) {
        this.engineConfigurationName = engineConfigurationName;
    }

    public String getprojectCustomFields() {
        return this.projectCustomFields;
    }

    public void setprojectCustomFields(String projectCustomFields) {
        this.projectCustomFields = projectCustomFields;
    }

    public boolean isOverrideRetentionRate() {
        return this.isOverrideRetentionRate;
    }

    public void setOverrideRetentionRate(boolean overrideRetentionRate) {
        this.isOverrideRetentionRate = overrideRetentionRate;
    }

    public CxScanConfig() {
    }

    public CxScanConfig(String url, String username, String password, String cxOrigin, boolean disableCertificateValidation) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.cxOrigin = cxOrigin;
        this.disableCertificateValidation = disableCertificateValidation;
    }

    public CxScanConfig(String url, String username, String password, String cxOrigin, String cxOriginUrl, boolean disableCertificateValidation) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.cxOrigin = cxOrigin;
        this.cxOriginUrl = cxOriginUrl;
        this.disableCertificateValidation = disableCertificateValidation;
    }

    public CxScanConfig(String url, String refreshToken, String cxOrigin, boolean disableCertificateValidation) {
        this.url = url;
        this.refreshToken = refreshToken;
        this.cxOrigin = cxOrigin;
        this.disableCertificateValidation = disableCertificateValidation;
    }

    public boolean isSastEnabled() {
        return this.scannerTypes.contains((Object)ScannerType.SAST);
    }

    public boolean isOsaEnabled() {
        return this.scannerTypes.contains((Object)ScannerType.OSA);
    }

    public boolean isAstScaEnabled() {
        return this.scannerTypes.contains((Object)ScannerType.AST_SCA);
    }

    public boolean isAstSastEnabled() {
        return this.scannerTypes.contains((Object)ScannerType.AST_SAST);
    }

    public void setSastEnabled(boolean sastEnabled) {
        if (sastEnabled) {
            this.scannerTypes.add(ScannerType.SAST);
        } else {
            this.scannerTypes.remove((Object)ScannerType.SAST);
        }
    }

    public String getCxOrigin() {
        return this.cxOrigin;
    }

    public String getCxOriginUrl() {
        return this.cxOriginUrl;
    }

    public void setCxOrigin(String cxOrigin) {
        this.cxOrigin = cxOrigin;
    }

    public void setCxOriginUrl(String cxOriginUrl) {
        this.cxOriginUrl = cxOriginUrl;
    }

    public boolean isDisableCertificateValidation() {
        return this.disableCertificateValidation;
    }

    public void setDisableCertificateValidation(boolean disableCertificateValidation) {
        this.disableCertificateValidation = disableCertificateValidation;
    }

    public boolean isUseSSOLogin() {
        return this.useSSOLogin;
    }

    public void setUseSSOLogin(boolean useSSOLogin) {
        this.useSSOLogin = useSSOLogin;
    }

    public Boolean getAvoidDuplicateProjectScans() {
        return this.avoidDuplicateProjectScans;
    }

    public boolean isEnableDataRetention() {
        return this.enableDataRetention;
    }

    public void setEnableDataRetention(boolean enableDataRetention) {
        this.enableDataRetention = enableDataRetention;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    public String getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(String customFields) {
        this.customFields = customFields;
    }

    public String getProjectLevelCustomFields() {
        return this.projectLevelCustomFields;
    }

    public void setProjectLevelCustomFields(String projectLevelCustomFields) {
        this.projectLevelCustomFields = projectLevelCustomFields;
    }

    public String getOsaLocationPath() {
        return this.osaLocationPath;
    }

    public void setOsaLocationPath(String osaLocationPath) {
        this.osaLocationPath = osaLocationPath;
    }

    public String getEffectiveSourceDirForDependencyScan() {
        return this.osaLocationPath != null ? this.osaLocationPath : this.sourceDir;
    }

    public File getReportsDir() {
        return this.reportsDir;
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir = reportsDir;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setRefreshToken(String token) {
        this.refreshToken = token;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getScaJsonReport() {
        return this.scaJsonReport;
    }

    public void setScaJsonReport(String scaJsonReport) {
        this.scaJsonReport = scaJsonReport;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTeamPath() {
        return this.teamPath;
    }

    public void setTeamPath(String teamPath) {
        if (!(StringUtils.isEmpty((CharSequence)teamPath) || teamPath.startsWith("\\") || teamPath.startsWith("/"))) {
            teamPath = "/" + teamPath;
        }
        if (!StringUtils.isEmpty((CharSequence)teamPath) && teamPath != null) {
            teamPath = teamPath.replace("\\", "/");
        }
        this.teamPath = teamPath;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public Boolean getDenyProject() {
        return this.denyProject;
    }

    public void setDenyProject(Boolean denyProject) {
        this.denyProject = denyProject;
    }

    public Boolean getPublic() {
        return this.isPublic;
    }

    public void setPublic(Boolean aPublic) {
        this.isPublic = aPublic;
    }

    public Boolean getForceScan() {
        return this.forceScan;
    }

    public void setForceScan(Boolean forceScan) {
        this.forceScan = forceScan;
    }

    public String getPresetName() {
        return this.presetName;
    }

    public void setPresetName(String presetName) {
        this.presetName = presetName;
    }

    public Integer getPresetId() {
        return this.presetId;
    }

    public void setPresetId(Integer presetId) {
        this.presetId = presetId;
    }

    public String getSastFolderExclusions() {
        return this.sastFolderExclusions;
    }

    public String getPostScanName() {
        return this.postScanName;
    }

    public void setPostScanName(String postScanName) {
        this.postScanName = postScanName;
    }

    public void setSastFolderExclusions(String sastFolderExclusions) {
        this.sastFolderExclusions = sastFolderExclusions;
    }

    public Integer getProjectRetentionRate() {
        return this.projectRetentionRate;
    }

    public void setProjectRetentionRate(Integer projectRetentionRate) {
        this.projectRetentionRate = projectRetentionRate;
    }

    public String getSastFilterPattern() {
        return this.sastFilterPattern;
    }

    public void setSastFilterPattern(String sastFilterPattern) {
        this.sastFilterPattern = sastFilterPattern;
    }

    public Integer getSastScanTimeoutInMinutes() {
        return this.sastScanTimeoutInMinutes == null ? -1 : this.sastScanTimeoutInMinutes;
    }

    public Integer getSCAScanTimeoutInMinutes() {
        return this.scaScanTimeoutInMinutes == null ? -1 : this.scaScanTimeoutInMinutes;
    }

    public void setSCAScanTimeoutInMinutes(Integer scaScanTimeoutInMinutes) {
        this.scaScanTimeoutInMinutes = scaScanTimeoutInMinutes;
    }

    public void setSastScanTimeoutInMinutes(Integer sastScanTimeoutInMinutes) {
        this.sastScanTimeoutInMinutes = sastScanTimeoutInMinutes;
    }

    public Integer getOsaScanTimeoutInMinutes() {
        return this.osaScanTimeoutInMinutes == null ? -1 : this.osaScanTimeoutInMinutes;
    }

    public void setOsaScanTimeoutInMinutes(Integer sastOsaScanTimeoutInMinutes) {
        this.osaScanTimeoutInMinutes = sastOsaScanTimeoutInMinutes;
    }

    public String getScanComment() {
        return this.scanComment;
    }

    public void setScanComment(String scanComment) {
        this.scanComment = scanComment;
    }

    public Boolean getIncremental() {
        return this.isIncremental;
    }

    public void setIncremental(Boolean incremental) {
        this.isIncremental = incremental;
    }

    public Boolean getSynchronous() {
        return this.isSynchronous;
    }

    public void setSynchronous(Boolean synchronous) {
        this.isSynchronous = synchronous;
    }

    public Boolean getSastEnableCriticalSeverity() {
        return this.sastEnableCriticalSeverity;
    }

    public void setSastEnableCriticalSeverity(Boolean sastEnableCriticalSeverity) {
        this.sastEnableCriticalSeverity = sastEnableCriticalSeverity;
    }

    public Boolean getSastThresholdsEnabled() {
        return this.sastThresholdsEnabled;
    }

    public void setSastThresholdsEnabled(Boolean sastThresholdsEnabled) {
        this.sastThresholdsEnabled = sastThresholdsEnabled;
    }

    public Integer getSastCriticalThreshold() {
        return this.sastCriticalThreshold;
    }

    public void setSastCriticalThreshold(Integer sastCriticalThreshold) {
        this.sastCriticalThreshold = sastCriticalThreshold;
    }

    public Integer getSastHighThreshold() {
        return this.sastHighThreshold;
    }

    public void setSastHighThreshold(Integer sastHighThreshold) {
        this.sastHighThreshold = sastHighThreshold;
    }

    public Integer getSastMediumThreshold() {
        return this.sastMediumThreshold;
    }

    public void setSastMediumThreshold(Integer sastMediumThreshold) {
        this.sastMediumThreshold = sastMediumThreshold;
    }

    public Integer getSastLowThreshold() {
        return this.sastLowThreshold;
    }

    public void setSastLowThreshold(Integer sastLowThreshold) {
        this.sastLowThreshold = sastLowThreshold;
    }

    public String getSastNewResultsThresholdSeverity() {
        return this.sastNewResultsThresholdSeverity;
    }

    public void setSastNewResultsThresholdSeverity(String sastNewResultsThresholdSeverity) {
        this.sastNewResultsThresholdSeverity = sastNewResultsThresholdSeverity;
    }

    public Boolean getSastNewResultsThresholdEnabled() {
        return this.sastNewResultsThresholdEnabled;
    }

    public void setSastNewResultsThresholdEnabled(Boolean sastNewResultsThresholdEnabled) {
        this.sastNewResultsThresholdEnabled = sastNewResultsThresholdEnabled;
    }

    public Boolean getGeneratePDFReport() {
        return this.generatePDFReport;
    }

    public void setGeneratePDFReport(Boolean generatePDFReport) {
        this.generatePDFReport = generatePDFReport;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    public Integer getEngineConfigurationId() {
        return this.engineConfigurationId;
    }

    public void setEngineConfigurationId(Integer engineConfigurationId) {
        this.engineConfigurationId = engineConfigurationId;
    }

    public String getOsaFilterPattern() {
        return this.osaFilterPattern;
    }

    public String getOsaFolderExclusions() {
        return this.osaFolderExclusions;
    }

    public void setOsaFolderExclusions(String osaFolderExclusions) {
        this.osaFolderExclusions = osaFolderExclusions;
    }

    public void setOsaFilterPattern(String osaFilterPattern) {
        this.osaFilterPattern = osaFilterPattern;
    }

    public String getOsaArchiveIncludePatterns() {
        return this.osaArchiveIncludePatterns;
    }

    public void setOsaArchiveIncludePatterns(String osaArchiveIncludePatterns) {
        this.osaArchiveIncludePatterns = osaArchiveIncludePatterns;
    }

    public Boolean getOsaRunInstall() {
        return this.osaRunInstall;
    }

    public void setOsaRunInstall(Boolean osaRunInstall) {
        this.osaRunInstall = osaRunInstall;
    }

    public Boolean getOsaThresholdsEnabled() {
        return this.osaThresholdsEnabled;
    }

    public void setOsaThresholdsEnabled(Boolean osaThresholdsEnabled) {
        this.osaThresholdsEnabled = osaThresholdsEnabled;
    }

    public Boolean isOsaFailOnError() {
        return this.osaFailOnError;
    }

    public void setOsaFailOnError(Boolean osaFailOnError) {
        this.osaFailOnError = osaFailOnError;
    }

    public Integer getOsaCriticalThreshold() {
        return this.osaCriticalThreshold;
    }

    public void setOsaCriticalThreshold(Integer osaCriticalThreshold) {
        this.osaCriticalThreshold = osaCriticalThreshold;
    }

    public Integer getOsaHighThreshold() {
        return this.osaHighThreshold;
    }

    public void setOsaHighThreshold(Integer osaHighThreshold) {
        this.osaHighThreshold = osaHighThreshold;
    }

    public Integer getOsaMediumThreshold() {
        return this.osaMediumThreshold;
    }

    public void setOsaMediumThreshold(Integer osaMediumThreshold) {
        this.osaMediumThreshold = osaMediumThreshold;
    }

    public Integer getOsaLowThreshold() {
        return this.osaLowThreshold;
    }

    public void setOsaLowThreshold(Integer osaLowThreshold) {
        this.osaLowThreshold = osaLowThreshold;
    }

    public Properties getOsaFsaConfig() {
        return this.osaFsaConfig;
    }

    public void setOsaFsaConfig(Properties osaFsaConfig) {
        this.osaFsaConfig = osaFsaConfig;
    }

    public String getOsaDependenciesJson() {
        return this.osaDependenciesJson;
    }

    public boolean isSASTThresholdEffectivelyEnabled() {
        return this.isSastEnabled() && this.getSastThresholdsEnabled() != false && (this.getSastCriticalThreshold() != null || this.getSastHighThreshold() != null || this.getSastMediumThreshold() != null || this.getSastLowThreshold() != null);
    }

    public boolean isOSAThresholdEffectivelyEnabled() {
        return !(!this.isOsaEnabled() && !this.isAstScaEnabled() || this.getOsaThresholdsEnabled() == false || this.getOsaCriticalThreshold() == null && this.getOsaHighThreshold() == null && this.getOsaMediumThreshold() == null && this.getOsaLowThreshold() == null);
    }

    public void setOsaDependenciesJson(String osaDependenciesJson) {
        this.osaDependenciesJson = osaDependenciesJson;
    }

    public Boolean getOsaGenerateJsonReport() {
        return this.osaGenerateJsonReport;
    }

    public void setOsaGenerateJsonReport(Boolean osaGenerateJsonReport) {
        this.osaGenerateJsonReport = osaGenerateJsonReport;
    }

    public boolean getEnablePolicyViolations() {
        return this.enablePolicyViolations;
    }

    public boolean getEnablePolicyViolationsSCA() {
        return this.enablePolicyViolationsSCA;
    }

    public void setEnablePolicyViolations(boolean enablePolicyViolations) {
        this.enablePolicyViolations = enablePolicyViolations;
    }

    public void setEnablePolicyViolationsSCA(boolean enablePolicyViolationsSCA) {
        this.enablePolicyViolationsSCA = enablePolicyViolationsSCA;
    }

    public boolean isEnablePolicyViolations() {
        return this.enablePolicyViolations;
    }

    public boolean isEnablePolicyViolationsSCA() {
        return this.enablePolicyViolationsSCA;
    }

    public Boolean isSASTversionCompitable() {
        if ((double)Float.parseFloat(this.cxVersion.getVersion()) >= 9.6) {
            return false;
        }
        return true;
    }

    public String getCxARMUrl() {
        return this.cxARMUrl;
    }

    public void setCxARMUrl(String cxARMUrl) {
        this.cxARMUrl = cxARMUrl;
    }

    public Boolean getHideResults() {
        return this.hideResults;
    }

    public void setHideResults(Boolean hideResults) {
        this.hideResults = hideResults;
    }

    public Boolean getContinueBuild() {
        return this.continueBuild;
    }

    public void setContinueBuild(Boolean continueBuild) {
        this.continueBuild = continueBuild;
    }

    public Boolean isAvoidDuplicateProjectScans() {
        return this.avoidDuplicateProjectScans;
    }

    public void setAvoidDuplicateProjectScans(Boolean avoidDuplicateProjectScans) {
        this.avoidDuplicateProjectScans = avoidDuplicateProjectScans;
    }

    public String getRemoteSrcUser() {
        return this.remoteSrcUser;
    }

    public void setRemoteSrcUser(String remoteSrcUser) {
        this.remoteSrcUser = remoteSrcUser;
    }

    public String getRemoteSrcPass() {
        return this.remoteSrcPass;
    }

    public void setRemoteSrcPass(String remoteSrcPass) {
        this.remoteSrcPass = remoteSrcPass;
    }

    public String getRemoteSrcUrl() {
        return this.remoteSrcUrl;
    }

    public void setRemoteSrcUrl(String remoteSrcUrl) {
        this.remoteSrcUrl = remoteSrcUrl;
    }

    public int getRemoteSrcPort() {
        return this.remoteSrcPort;
    }

    public void setRemoteSrcPort(int remoteSrcPort) {
        this.remoteSrcPort = remoteSrcPort;
    }

    public byte[] getRemoteSrcKeyFile() {
        return this.remoteSrcKeyFile;
    }

    public void setRemoteSrcKeyFile(byte[] remoteSrcKeyFile) {
        this.remoteSrcKeyFile = remoteSrcKeyFile;
    }

    public RemoteSourceTypes getRemoteType() {
        return this.remoteType;
    }

    public void setRemoteType(RemoteSourceTypes remoteType) {
        this.remoteType = remoteType;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public void setPaths(String[] paths) {
        this.paths = paths;
    }

    public String getRemoteSrcBranch() {
        return this.remoteSrcBranch;
    }

    public void setRemoteSrcBranch(String remoteSrcBranch) {
        this.remoteSrcBranch = remoteSrcBranch;
    }

    public String getPerforceMode() {
        return this.perforceMode;
    }

    public void setPerforceMode(String perforceMode) {
        this.perforceMode = perforceMode;
    }

    public Boolean getGenerateXmlReport() {
        return this.generateXmlReport;
    }

    public void setGenerateXmlReport(Boolean generateXmlReport) {
        this.generateXmlReport = generateXmlReport;
    }

    public CxVersion getCxVersion() {
        return this.cxVersion;
    }

    public void setCxVersion(CxVersion cxVersion) {
        this.cxVersion = cxVersion;
    }

    public Integer getProgressInterval() {
        return this.progressInterval;
    }

    public void setProgressInterval(Integer progressInterval) {
        this.progressInterval = progressInterval;
    }

    public Integer getOsaProgressInterval() {
        return this.osaProgressInterval;
    }

    public void setOsaProgressInterval(Integer osaProgressInterval) {
        this.osaProgressInterval = osaProgressInterval;
    }

    public Integer getConnectionRetries() {
        return this.connectionRetries;
    }

    public void setConnectionRetries(Integer connectionRetries) {
        this.connectionRetries = connectionRetries;
    }

    public String getMvnPath() {
        return this.mvnPath;
    }

    public void setMvnPath(String mvnPath) {
        this.mvnPath = mvnPath;
    }

    public String getOsaScanDepth() {
        return this.osaScanDepth;
    }

    public void setOsaScanDepth(String osaScanDepth) {
        this.osaScanDepth = osaScanDepth;
    }

    public Integer getMaxZipSize() {
        return this.maxZipSize;
    }

    public void setMaxZipSize(Integer maxZipSize) {
        this.maxZipSize = maxZipSize;
    }

    public String getDefaultProjectName() {
        return this.defaultProjectName;
    }

    public void setDefaultProjectName(String defaultProjectName) {
        this.defaultProjectName = defaultProjectName;
    }

    public Map<ReportType, String> getReports() {
        return this.reports;
    }

    public void addPDFReport(String pdfReportPath) {
        this.reports.put(ReportType.PDF, pdfReportPath);
    }

    public void addXMLReport(String xmlReportPath) {
        this.reports.put(ReportType.XML, xmlReportPath);
    }

    public void addCSVReport(String csvReportPath) {
        this.reports.put(ReportType.CSV, csvReportPath);
    }

    public void addRTFReport(String rtfReportPath) {
        this.reports.put(ReportType.RTF, rtfReportPath);
    }

    public AstScaConfig getAstScaConfig() {
        return this.astScaConfig;
    }

    public void setAstScaConfig(AstScaConfig astScaConfig) {
        this.astScaConfig = astScaConfig;
    }

    public AstSastConfig getAstSastConfig() {
        return this.astSastConfig;
    }

    public void setAstSastConfig(AstSastConfig astConfig) {
        this.astSastConfig = astConfig;
    }

    public Set<ScannerType> getScannerTypes() {
        return this.scannerTypes;
    }

    public void addScannerType(ScannerType scannerType) {
        this.scannerTypes.add(scannerType);
    }

    public boolean isSastOrOSAEnabled() {
        return this.isSastEnabled() || this.isOsaEnabled();
    }

    public Boolean isProxy() {
        return this.isProxy;
    }

    public void setProxy(Boolean proxy) {
        this.isProxy = proxy;
    }

    public Boolean isScaProxy() {
        return this.isScaProxy;
    }

    public void setScaProxy(Boolean scaProxy) {
        this.isScaProxy = scaProxy;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public ProxyConfig getScaProxyConfig() {
        return this.proxyScaConfig;
    }

    public void setScaProxyConfig(ProxyConfig proxyScaConfig) {
        this.proxyScaConfig = proxyScaConfig;
    }

    public void addCookie(Cookie cookie) {
        this.sessionCookies.add(cookie);
    }

    public List<Cookie> getSessionCookie() {
        return this.sessionCookies;
    }

    public TokenLoginResponse getToken() {
        return this.token;
    }

    public void setToken(TokenLoginResponse token) {
        this.token = token;
    }

    public Boolean getNTLM() {
        return this.useNTLM;
    }

    public void setNTLM(Boolean ntlm) {
        this.useNTLM = ntlm;
    }

    public boolean getIsOverrideProjectSetting() {
        return this.isOverrideProjectSetting;
    }

    public void setIsOverrideProjectSetting(boolean isOverrideProjectSetting) {
        this.isOverrideProjectSetting = isOverrideProjectSetting;
    }

    public Integer getPostScanActionId() {
        return this.postScanActionId;
    }

    public void setPostScanActionId(Integer postScanActionId) {
        this.postScanActionId = postScanActionId;
    }

    public final boolean isIgnoreBenignErrors() {
        return this.ignoreBenignErrors;
    }

    public final void setIgnoreBenignErrors(boolean ignoreBenignErrors) {
        this.ignoreBenignErrors = ignoreBenignErrors;
    }

    public Boolean isEnableSASTBranching() {
        return this.enableSastBranching;
    }

    public void setEnableSASTBranching(Boolean enableSASTBranching) {
        this.enableSastBranching = enableSASTBranching;
    }

    public String getMasterBranchProjName() {
        return this.masterBranchProjName;
    }

    public void setMasterBranchProjName(String masterBranchProjName) {
        this.masterBranchProjName = masterBranchProjName;
    }

    public boolean isGenerateScaReport() {
        return this.generateScaReport;
    }

    public void setGenerateScaReport(boolean generateScaReport) {
        this.generateScaReport = generateScaReport;
    }

    public String getScaReportFormat() {
        return this.scaReportFormat;
    }

    public void setScaReportFormat(String scaReportFormat) {
        this.scaReportFormat = scaReportFormat;
    }

    public Integer getcopyBranchTimeOutInSeconds() {
        return this.copyBranchTimeOutInSeconds;
    }

    public void setcopyBranchTimeOutInSeconds(Integer copyBranchTimeOutInSeconds) {
        this.copyBranchTimeOutInSeconds = copyBranchTimeOutInSeconds;
    }
}

