/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.common.summary;

import com.cx.restclient.ast.dto.sca.AstScaResults;
import com.cx.restclient.ast.dto.sca.report.Finding;
import com.cx.restclient.common.ShragaUtils;
import com.cx.restclient.dto.Results;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.dto.scansummary.Severity;
import com.cx.restclient.osa.dto.CVEReportTableRow;
import com.cx.restclient.osa.dto.OSAResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DependencyScanResult
extends Results
implements Serializable {
    private ScannerType scannerType;
    private boolean resultReady;
    private int criticalVulnerability;
    private int highVulnerability;
    private int mediumVulnerability;
    private int lowVulnerability;
    private String summaryLink;
    private int vulnerableAndOutdated;
    private int nonVulnerableLibraries;
    private String scanStartTime;
    private String scanEndTime;
    private List<CVEReportTableRow> dependencyCriticalCVEReportTable = new ArrayList<CVEReportTableRow>();
    private List<CVEReportTableRow> dependencyHighCVEReportTable = new ArrayList<CVEReportTableRow>();
    private List<CVEReportTableRow> dependencyMediumCVEReportTable = new ArrayList<CVEReportTableRow>();
    private List<CVEReportTableRow> dependencyLowCVEReportTable = new ArrayList<CVEReportTableRow>();
    private int totalLibraries;

    DependencyScanResult() {
    }

    DependencyScanResult(AstScaResults scaResults) {
        scaResults.calculateVulnerableAndOutdatedPackages();
        this.scannerType = ScannerType.AST_SCA;
        this.criticalVulnerability = scaResults.getSummary().getCriticalVulnerabilityCount();
        this.highVulnerability = scaResults.getSummary().getHighVulnerabilityCount();
        this.mediumVulnerability = scaResults.getSummary().getMediumVulnerabilityCount();
        this.lowVulnerability = scaResults.getSummary().getLowVulnerabilityCount();
        this.resultReady = scaResults.isScaResultReady();
        this.summaryLink = scaResults.getWebReportLink();
        this.vulnerableAndOutdated = scaResults.getVulnerableAndOutdated();
        this.nonVulnerableLibraries = scaResults.getNonVulnerableLibraries();
        this.scanStartTime = ShragaUtils.formatDate(scaResults.getSummary().getCreatedOn(), "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS", "dd/MM/yy HH:mm");
        this.scanEndTime = "";
        this.setDependencyCVEReportTableSCA(scaResults.getFindings());
        this.setTotalLibraries(scaResults.getSummary().getTotalPackages());
    }

    DependencyScanResult(OSAResults osaResults) {
        this.scannerType = ScannerType.OSA;
        this.highVulnerability = osaResults.getResults().getTotalHighVulnerabilities();
        this.mediumVulnerability = osaResults.getResults().getTotalMediumVulnerabilities();
        this.lowVulnerability = osaResults.getResults().getTotalLowVulnerabilities();
        this.resultReady = osaResults.isOsaResultsReady();
        this.summaryLink = osaResults.getOsaProjectSummaryLink();
        this.vulnerableAndOutdated = osaResults.getResults().getVulnerableAndOutdated();
        this.nonVulnerableLibraries = osaResults.getResults().getNonVulnerableLibraries();
        this.scanStartTime = osaResults.getScanStartTime();
        this.scanEndTime = osaResults.getScanEndTime();
        this.setDependencyCVEReportTableOsa(osaResults.getOsaLowCVEReportTable(), osaResults.getOsaMediumCVEReportTable(), osaResults.getOsaHighCVEReportTable(), osaResults.getOsaCriticalCVEReportTable());
        this.setTotalLibraries(osaResults.getResults().getTotalLibraries());
    }

    public void setDependencyCVEReportTableOsa(List<CVEReportTableRow> osaCVEResultsLow, List<CVEReportTableRow> osaCVEResultsMedium, List<CVEReportTableRow> osaCVEResultsHigh, List<CVEReportTableRow> osaCVEResultsCritical) {
        CVEReportTableRow row;
        Iterator<CVEReportTableRow> iterator = osaCVEResultsLow.iterator();
        while (iterator.hasNext()) {
            CVEReportTableRow lowCVE;
            row = lowCVE = iterator.next();
            this.dependencyLowCVEReportTable.add(row);
        }
        iterator = osaCVEResultsMedium.iterator();
        while (iterator.hasNext()) {
            CVEReportTableRow mediumCVE;
            row = mediumCVE = iterator.next();
            this.dependencyMediumCVEReportTable.add(row);
        }
        iterator = osaCVEResultsHigh.iterator();
        while (iterator.hasNext()) {
            CVEReportTableRow highCVE;
            row = highCVE = iterator.next();
            this.dependencyHighCVEReportTable.add(row);
        }
        iterator = osaCVEResultsCritical.iterator();
        while (iterator.hasNext()) {
            CVEReportTableRow criticalCVE;
            row = criticalCVE = iterator.next();
            this.dependencyCriticalCVEReportTable.add(row);
        }
    }

    public void setDependencyCVEReportTableSCA(List<Finding> scaFindings) {
        for (Finding scaFinding : scaFindings) {
            CVEReportTableRow row = new CVEReportTableRow(scaFinding);
            if (scaFinding.getSeverity() == Severity.LOW) {
                this.dependencyLowCVEReportTable.add(row);
                continue;
            }
            if (scaFinding.getSeverity() == Severity.MEDIUM) {
                this.dependencyMediumCVEReportTable.add(row);
                continue;
            }
            if (scaFinding.getSeverity() == Severity.HIGH) {
                this.dependencyHighCVEReportTable.add(row);
                continue;
            }
            if (scaFinding.getSeverity() != Severity.CRITICAL) continue;
            this.dependencyCriticalCVEReportTable.add(row);
        }
    }

    public ScannerType getScannerType() {
        return this.scannerType;
    }

    public void setScannerType(ScannerType scannerType) {
        this.scannerType = scannerType;
    }

    public boolean isResultReady() {
        return this.resultReady;
    }

    public void setResultReady(boolean resultReady) {
        this.resultReady = resultReady;
    }

    public int getCriticalVulnerability() {
        return this.criticalVulnerability;
    }

    public void setCriticalVulnerability(int criticalVulnerability) {
        this.criticalVulnerability = criticalVulnerability;
    }

    public int getHighVulnerability() {
        return this.highVulnerability;
    }

    public void setHighVulnerability(int highVulnerability) {
        this.highVulnerability = highVulnerability;
    }

    public int getMediumVulnerability() {
        return this.mediumVulnerability;
    }

    public void setMediumVulnerability(int mediumVulnerability) {
        this.mediumVulnerability = mediumVulnerability;
    }

    public int getLowVulnerability() {
        return this.lowVulnerability;
    }

    public void setLowVulnerability(int lowVulnerability) {
        this.lowVulnerability = lowVulnerability;
    }

    public String getSummaryLink() {
        return this.summaryLink;
    }

    public void setSummaryLink(String summaryLink) {
        this.summaryLink = summaryLink;
    }

    public int getVulnerableAndOutdated() {
        return this.vulnerableAndOutdated;
    }

    public void setVulnerableAndOutdated(int vulnerableAndOutdated) {
        this.vulnerableAndOutdated = vulnerableAndOutdated;
    }

    public int getNonVulnerableLibraries() {
        return this.nonVulnerableLibraries;
    }

    public void setNonVulnerableLibraries(int nonVulnerableLibraries) {
        this.nonVulnerableLibraries = nonVulnerableLibraries;
    }

    public String getScanStartTime() {
        return this.scanStartTime;
    }

    public void setScanStartTime(String scanStartTime) {
        this.scanStartTime = scanStartTime;
    }

    public String getScanEndTime() {
        return this.scanEndTime;
    }

    public void setScanEndTime(String scanEndTime) {
        this.scanEndTime = scanEndTime;
    }

    public List<CVEReportTableRow> getDependencyCriticalCVEReportTable() {
        return this.dependencyCriticalCVEReportTable;
    }

    public void setDependencyCriticalCVEReportTable(List<CVEReportTableRow> dependencyCriticalCVEReportTable) {
        this.dependencyCriticalCVEReportTable = dependencyCriticalCVEReportTable;
    }

    public List<CVEReportTableRow> getDependencyHighCVEReportTable() {
        return this.dependencyHighCVEReportTable;
    }

    public void setDependencyHighCVEReportTable(List<CVEReportTableRow> dependencyHighCVEReportTable) {
        this.dependencyHighCVEReportTable = dependencyHighCVEReportTable;
    }

    public List<CVEReportTableRow> getDependencyMediumCVEReportTable() {
        return this.dependencyMediumCVEReportTable;
    }

    public void setDependencyMediumCVEReportTable(List<CVEReportTableRow> dependencyMediumCVEReportTable) {
        this.dependencyMediumCVEReportTable = dependencyMediumCVEReportTable;
    }

    public List<CVEReportTableRow> getDependencyLowCVEReportTable() {
        return this.dependencyLowCVEReportTable;
    }

    public void setDependencyLowCVEReportTable(List<CVEReportTableRow> dependencyLowCVEReportTable) {
        this.dependencyLowCVEReportTable = dependencyLowCVEReportTable;
    }

    public int getTotalLibraries() {
        return this.totalLibraries;
    }

    public void setTotalLibraries(int totalLibraries) {
        this.totalLibraries = totalLibraries;
    }
}

