/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.common;

import com.cx.restclient.dto.BaseStatus;
import com.cx.restclient.dto.Status;
import com.cx.restclient.exception.CxClientException;
import java.io.IOException;
import java.util.Date;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Waiter<T extends BaseStatus> {
    public static final Logger log = LoggerFactory.getLogger(Waiter.class);
    private static final String FAILED_MSG = "Failed to get status from ";
    private int retry;
    private String scanType;
    private int sleepIntervalSec;
    private long startTimeSec;

    public Waiter(String scanType, int interval, int retry) {
        this.scanType = scanType;
        this.sleepIntervalSec = interval;
        this.retry = retry;
    }

    public T waitForTaskToFinish(String taskId, Integer scanTimeoutSec, Logger log) throws CxClientException {
        this.startTimeSec = System.currentTimeMillis() / 1000L;
        long elapsedTimeSec = 0L;
        BaseStatus statusResponse = null;
        int initialReset = this.retry;
        try {
            do {
                block8: {
                    try {
                        Thread.sleep((long)this.sleepIntervalSec * 1000L);
                        statusResponse = (BaseStatus)this.getStatus(taskId);
                        this.retry = initialReset;
                    }
                    catch (IOException e) {
                        log.debug(FAILED_MSG + this.scanType + ". retrying (" + (this.retry - 1) + " tries left). Error message: " + e.getMessage());
                        --this.retry;
                        if (this.retry <= 0) {
                            throw new CxClientException(FAILED_MSG + this.scanType + ". Error message: " + e.getMessage(), e);
                        }
                        if (statusResponse != null && statusResponse.getBaseStatus() != null) continue;
                        statusResponse = new BaseStatus(Status.SOURCE_PULLING_AND_DEPLOYMENT);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        if (!Thread.interrupted()) break block8;
                        throw new CxClientException(e.getMessage());
                    }
                }
                elapsedTimeSec = new Date().getTime() / 1000L - this.startTimeSec;
                this.printProgress(statusResponse);
            } while (this.isTaskInProgress(statusResponse) && (scanTimeoutSec <= 0 || elapsedTimeSec < (long)scanTimeoutSec.intValue()));
            if (scanTimeoutSec > 0 && (long)scanTimeoutSec.intValue() <= elapsedTimeSec) {
                throw new ConditionTimeoutException("Failed to perform " + this.scanType + ": " + this.scanType + " has been automatically aborted: reached the user-specified timeout (" + scanTimeoutSec / 60 + " minutes)");
            }
        }
        catch (CxClientException e) {
            throw new CxClientException(FAILED_MSG + this.scanType + ". Error message: " + e.getMessage(), e);
        }
        return this.resolveStatus(statusResponse);
    }

    public abstract T getStatus(String var1) throws CxClientException, IOException;

    public abstract void printProgress(T var1);

    public abstract T resolveStatus(T var1) throws CxClientException;

    public boolean isTaskInProgress(T statusResponse) {
        Status status = ((BaseStatus)statusResponse).getBaseStatus();
        return status.equals((Object)Status.IN_PROGRESS);
    }

    public long getStartTimeSec() {
        return this.startTimeSec;
    }
}

