/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.ast;

import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.sast.utils.zip.CxZipUtils;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;

public class SpawnScaResolver {
    public static final String SCA_RESOLVER_EXE = "\\ScaResolver.exe";
    public static final String SCA_RESOLVER_FOR_LINUX = "/ScaResolver";
    public static final String OFFLINE = "offline";

    protected static int runScaResolver(String pathToScaResolver, String scaResolverAddParams, String pathToResultJSONFile, String pathToSASTResultJSONFile, Logger log) throws CxClientException {
        int exitCode;
        block41: {
            Path parent;
            exitCode = -100;
            ArrayList<String> arguments = new ArrayList<String>();
            Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(scaResolverAddParams.trim());
            while (m.find()) {
                arguments.add(m.group(1));
            }
            String[] scaResolverCommand = new String[arguments.size() + 2];
            try {
                for (int i = 0; i < arguments.size() - 1; ++i) {
                    String src;
                    String arg = (String)arguments.get(i);
                    log.info(arg);
                    if (!"-s".equals(arg) || !(src = ((String)arguments.get(i + 1)).replace("\"", "")).toLowerCase().endsWith(".zip")) continue;
                    String tempDir = CxZipUtils.extractZipToTempDirectory(src, log, "sca");
                    arguments.set(i + 1, tempDir);
                }
            }
            catch (IOException e) {
                CxZipUtils.cleanupTempExtractedDir(log);
                throw new CxClientException("Failed to unzip source archive", e);
            }
            pathToScaResolver = !SystemUtils.IS_OS_UNIX ? pathToScaResolver + SCA_RESOLVER_EXE : pathToScaResolver + SCA_RESOLVER_FOR_LINUX;
            log.debug("Starting build CMD command");
            scaResolverCommand[0] = pathToScaResolver;
            scaResolverCommand[1] = OFFLINE;
            boolean configGiven = false;
            for (int i = 0; i < arguments.size(); ++i) {
                String arg;
                scaResolverCommand[i + 2] = arg = (String)arguments.get(i);
                if (arg.equals("-r") || "--resolver-result-path".equals(arg)) {
                    while (pathToResultJSONFile.contains("\"")) {
                        pathToResultJSONFile = pathToResultJSONFile.replace("\"", "");
                    }
                    scaResolverCommand[i + 3] = pathToResultJSONFile;
                    ++i;
                    continue;
                }
                if (arg.equals("-c") || arg.equals("--config-path")) {
                    configGiven = true;
                    continue;
                }
                if (!"--sast-result-path".equals(arg)) continue;
                while (pathToSASTResultJSONFile.contains("\"")) {
                    pathToSASTResultJSONFile = pathToSASTResultJSONFile.replace("\"", "");
                }
                scaResolverCommand[i + 3] = pathToSASTResultJSONFile;
                ++i;
            }
            if (!configGiven && pathToResultJSONFile.equals("") && (parent = Paths.get(pathToResultJSONFile, new String[0]).getParent()) != null) {
                Path logDir = Paths.get(parent.toString(), "log");
                Path configPath = Paths.get(parent.toString(), "Configuration.ini");
                try {
                    Files.createDirectories(logDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    log.error("Could not create log directory: " + e.getMessage(), (Object[])e.getStackTrace());
                    throw new CxClientException(e);
                }
                try (FileWriter config = new FileWriter(configPath.toString());){
                    config.write("LogsDirectory=" + logDir);
                }
                catch (IOException e) {
                    log.error("Could not create configuration file: " + e.getMessage(), (Object[])e.getStackTrace());
                }
                log.debug("    --config-path " + configPath);
                scaResolverCommand[arguments.size()] = "--config-path";
                scaResolverCommand[arguments.size() + 1] = configPath.toString();
            }
            log.debug("Finished created CMD command");
            try {
                String line;
                BufferedReader reader;
                String[] command = scaResolverCommand;
                if (SystemUtils.IS_OS_UNIX) {
                    String tempPermissionValidation = "ls " + pathToScaResolver + " -ltr";
                    SpawnScaResolver.printExecCommandOutput(tempPermissionValidation, log);
                }
                log.info("Executing ScaResolver command.");
                Process process = Runtime.getRuntime().exec(command);
                try {
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    try {
                        line = null;
                        while ((line = reader.readLine()) != null) {
                            log.info(line);
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    log.error("Error while reading standard output: " + e.getMessage(), (Object[])e.getStackTrace());
                    throw new CxClientException(e);
                }
                try {
                    reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    try {
                        while ((line = reader.readLine()) != null) {
                            log.debug(line);
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    log.error("Error while reading error output: " + e.getMessage(), (Object[])e.getStackTrace());
                    throw new CxClientException(e);
                }
                exitCode = process.waitFor();
            }
            catch (IOException | InterruptedException e) {
                log.error("Failed to execute next command : " + scaResolverCommand, (Object)e.getMessage(), (Object)e.getStackTrace());
                Thread.currentThread().interrupt();
                if (!Thread.interrupted()) break block41;
                throw new CxClientException(e);
            }
        }
        return exitCode;
    }

    private static void printExecCommandOutput(String execCommand, Logger log) {
        try {
            String line;
            log.debug("Checking that next file has -rwxrwxrwx permissions " + execCommand);
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(execCommand);
            BufferedReader is = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = is.readLine()) != null) {
                log.debug(line);
            }
        }
        catch (Exception ex) {
            log.debug("Failed to run execute [%s] command ");
        }
    }
}

