/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.ast;

import com.cx.restclient.ast.AstClient;
import com.cx.restclient.ast.ClientTypeResolver;
import com.cx.restclient.ast.SpawnScaResolver;
import com.cx.restclient.ast.dto.common.HandlerRef;
import com.cx.restclient.ast.dto.common.RemoteRepositoryInfo;
import com.cx.restclient.ast.dto.common.ScanConfig;
import com.cx.restclient.ast.dto.sca.AstScaConfig;
import com.cx.restclient.ast.dto.sca.AstScaResults;
import com.cx.restclient.ast.dto.sca.CreateProjectRequest;
import com.cx.restclient.ast.dto.sca.Project;
import com.cx.restclient.ast.dto.sca.ScaScanConfigValue;
import com.cx.restclient.ast.dto.sca.Team;
import com.cx.restclient.ast.dto.sca.UpdateProjectRequest;
import com.cx.restclient.ast.dto.sca.report.AstScaSummaryResults;
import com.cx.restclient.ast.dto.sca.report.Finding;
import com.cx.restclient.ast.dto.sca.report.Package;
import com.cx.restclient.ast.dto.sca.report.PolicyEvaluation;
import com.cx.restclient.common.CxPARAM;
import com.cx.restclient.common.Scanner;
import com.cx.restclient.common.UrlUtils;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.LoginSettings;
import com.cx.restclient.dto.PathFilter;
import com.cx.restclient.dto.Results;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.dto.SourceLocationType;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.exception.CxHTTPClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import com.cx.restclient.httpClient.utils.HttpClientHelper;
import com.cx.restclient.osa.dto.ClientType;
import com.cx.restclient.osa.utils.OSAUtils;
import com.cx.restclient.sast.utils.SASTUtils;
import com.cx.restclient.sast.utils.State;
import com.cx.restclient.sast.utils.zip.CxZipUtils;
import com.cx.restclient.sast.utils.zip.NewCxZipFile;
import com.cx.restclient.sast.utils.zip.Zipper;
import com.cx.restclient.sca.dto.CxSCAResolvingConfiguration;
import com.cx.restclient.sca.dto.SbomReportResponse;
import com.cx.restclient.sca.dto.ScanReportExportIdRequester;
import com.cx.restclient.sca.utils.CxSCAFileSystemUtils;
import com.cx.restclient.sca.utils.fingerprints.CxSCAScanFingerprints;
import com.cx.restclient.sca.utils.fingerprints.FingerprintCollector;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class AstScaClient
extends AstClient
implements Scanner {
    private static final String RISK_MANAGEMENT_API = properties.get("astSca.riskManagementApi");
    private static final String PROJECTS = RISK_MANAGEMENT_API + properties.get("astSca.projects");
    private static final String PROJECTID = PROJECTS + properties.get("astSca.projectId");
    private static final String SUMMARY_REPORT = RISK_MANAGEMENT_API + properties.get("astSca.summaryReport");
    private static final String FINDINGS = RISK_MANAGEMENT_API + properties.get("astSca.findings");
    private static final String PACKAGES = RISK_MANAGEMENT_API + properties.get("astSca.packages");
    private static final String LATEST_SCAN = RISK_MANAGEMENT_API + properties.get("astSca.latestScan");
    private static final String WEB_REPORT = properties.get("astSca.webReport");
    private static final String RESOLVING_CONFIGURATION_API = properties.get("astSca.resolvingConfigurationApi");
    private static final String REPORTID_API = RISK_MANAGEMENT_API + properties.get("astSca.reportId");
    private static final String POLICY_MANAGEMENT_API = properties.get("astSca.policyManagementApi");
    private static final String POLICY_MANAGEMENT_EVALUATION_API = POLICY_MANAGEMENT_API + properties.get("astSca.policyManagementEvaliation");
    private static final String TEAMBYID = properties.get("astSca.teamById");
    private static final String REPORT_SCA_PACKAGES = "cxSCAPackages";
    private static final String REPORT_SCA_FINDINGS = "cxSCAVulnerabilities";
    private static final String REPORT_SCA_SUMMARY = "cxSCASummary";
    private static final String JSON_EXTENSION = ".json";
    private static final String ENGINE_TYPE_FOR_API = "sca";
    private static final String TENANT_HEADER_NAME = "Account-Name";
    private static final ObjectMapper caseInsensitiveObjectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
    private final AstScaConfig astScaConfig;
    private String projectId;
    private String scanId;
    private String reportId;
    private File tempUploadFile;
    private final FingerprintCollector fingerprintCollector;
    private CxSCAResolvingConfiguration resolvingConfiguration;
    private static final String FINGERPRINT_FILE_NAME = ".cxsca.sig";
    private static final String SCA_CONFIG_FOLDER_NAME = ".cxsca.configurations";

    public AstScaClient(CxScanConfig config, Logger log) {
        super(config, log);
        this.astScaConfig = config.getAstScaConfig();
        this.validate(this.astScaConfig);
        this.httpClient = this.createHttpClient(this.astScaConfig.getApiUrl());
        this.resolvingConfiguration = null;
        this.fingerprintCollector = new FingerprintCollector(log);
        this.httpClient.addCustomHeader(TENANT_HEADER_NAME, config.getAstScaConfig().getTenant());
    }

    @Override
    protected String getScannerDisplayName() {
        return ScannerType.AST_SCA.getDisplayName();
    }

    @Override
    protected ScanConfig getScanConfig() {
        String sastProjectId = this.config.getAstScaConfig().getSastProjectId();
        String sastServerUrl = this.config.getAstScaConfig().getSastServerUrl();
        String sastUsername = this.config.getAstScaConfig().getSastUsername();
        String sastPassword = this.config.getAstScaConfig().getSastPassword();
        String sastProjectName = this.config.getAstScaConfig().getSastProjectName();
        Map<String, String> envVariables = this.config.getAstScaConfig().getEnvVariables();
        JSONObject envJsonString = new JSONObject(envVariables);
        ScaScanConfigValue configValue = ScaScanConfigValue.builder().environmentVariables(envJsonString.toString()).sastProjectId(sastProjectId).sastServerUrl(sastServerUrl).sastUsername(sastUsername).sastPassword(sastPassword).sastProjectName(sastProjectName).build();
        return ScanConfig.builder().type(ENGINE_TYPE_FOR_API).value(configValue).build();
    }

    @Override
    protected HandlerRef getBranchToScan(RemoteRepositoryInfo repoInfo) {
        if (StringUtils.isNotEmpty((CharSequence)repoInfo.getBranch())) {
            String message = String.format("Branch specification is not yet supported by %s.", this.getScannerDisplayName());
            throw new CxClientException(message);
        }
        return null;
    }

    @Override
    protected URL getEffectiveRepoUrl(RemoteRepositoryInfo repoInfo) {
        URL result;
        URL initialUrl = repoInfo.getUrl();
        String username = StringUtils.defaultString((String)repoInfo.getUsername());
        String password = StringUtils.defaultString((String)repoInfo.getPassword());
        try {
            if (StringUtils.isNotEmpty((CharSequence)username) || StringUtils.isNotEmpty((CharSequence)password)) {
                this.log.info("Adding credentials as the userinfo part of the URL, because {} only supports this kind of authentication.", (Object)this.getScannerDisplayName());
                result = new URIBuilder(initialUrl.toURI()).setUserInfo(username, password).build().toURL();
            } else {
                result = repoInfo.getUrl();
            }
        }
        catch (Exception e) {
            throw new CxClientException("Error getting effective repo URL.");
        }
        return result;
    }

    @Override
    public Results init() {
        this.log.debug("Initializing {} client.", (Object)this.getScannerDisplayName());
        AstScaResults scaResults = new AstScaResults();
        try {
            this.login();
        }
        catch (Exception e) {
            super.handleInitError(e, scaResults);
        }
        return scaResults;
    }

    public CxSCAResolvingConfiguration getCxSCAResolvingConfigurationForProject(String projectId) throws IOException {
        this.log.info("Resolving configuration for project: {}", (Object)projectId);
        String path = String.format(RESOLVING_CONFIGURATION_API, URLEncoder.encode(projectId, ENCODING));
        return this.httpClient.getRequest(path, "application/json", CxSCAResolvingConfiguration.class, 200, "get CxSCA resolving configuration", false);
    }

    private byte[] getExportIdForReport(String scanId, String contentType) throws IOException {
        try {
            ScanReportExportIdRequester scanReportExportIdRequester = new ScanReportExportIdRequester(scanId, contentType);
            StringEntity entity = new StringEntity(HttpClientHelper.convertToJson(scanReportExportIdRequester), StandardCharsets.UTF_8);
            String jsonResponse = this.httpClient.postRequest("/export/requests", "application/json", (HttpEntity)entity, String.class, 202, "failed to fetch export id");
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(jsonResponse);
            String exportId = root.get("exportId").asText();
            this.log.info("Export Id generated for " + contentType + " :: " + exportId);
            SbomReportResponse sbomReportResponse = this.getReportByExportId(exportId, contentType);
            return HttpClientHelper.getSBOMReport(sbomReportResponse.getFileUrl());
        }
        catch (Exception e) {
            this.log.error("Failed to getExportIdForReport :: ", (Throwable)e);
            return null;
        }
    }

    private SbomReportResponse getReportByExportId(String exportId, String contentType) throws IOException {
        return (SbomReportResponse)Awaitility.await().atMost(Duration.ofMinutes(2L)).pollInterval(Duration.ofSeconds(3L)).pollDelay(Duration.ZERO).until(() -> {
            try {
                SbomReportResponse response = this.httpClient.getRequest("/export/requests?exportId={export_id}".replace("{export_id}", exportId), contentType, SbomReportResponse.class, 200, " failed to fetch scan report for exportId :: " + exportId, false);
                if (response != null && response.getFileUrl() != null && !response.getFileUrl().isEmpty()) {
                    return response;
                }
            }
            catch (Exception e) {
                this.log.warn("Still waiting for report (exportId={})... {}", (Object)exportId, (Object)e.getMessage());
            }
            return null;
        }, Objects::nonNull);
    }

    private byte[] getReport(String scanId, String contentType) throws IOException {
        contentType = this.getContentType(contentType);
        return this.getExportIdForReport(scanId, contentType);
    }

    private String getContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        switch (contentType.toUpperCase()) {
            case "PDF": {
                return "ScanReportPdf";
            }
            case "XML": {
                return "ScanReportXml";
            }
            case "CSV": {
                return "ScanReportCsv";
            }
            case "JSON": {
                return "ScanReportJson";
            }
        }
        return contentType;
    }

    public static void writeReport(byte[] scanReport, String reportName, Logger log) {
        try {
            File reportFile = new File(reportName);
            if (!reportFile.isAbsolute()) {
                reportFile = new File(System.getProperty("user.dir") + CxPARAM.CX_REPORT_LOCATION + File.separator + reportFile);
            }
            if (!reportFile.getParentFile().exists()) {
                reportFile.getParentFile().mkdirs();
            }
            FileUtils.writeByteArrayToFile((File)reportFile, (byte[])scanReport);
            log.info("Report location: " + reportFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.error("Failed to write report: ", (Object)e.getMessage());
        }
    }

    @Override
    public Results waitForScanResults() {
        try {
            this.waitForScanToFinish(this.scanId);
            AstScaResults scaResults = this.tryGetScanResults().orElseThrow(() -> new CxClientException("Unable to get scan results: scan not found."));
            if (this.config.getScaJsonReport() != null) {
                OSAUtils.writeJsonToFile("cxSCAVulnerabilities.json", scaResults.getFindings(), this.config.getReportsDir(), this.config.getOsaGenerateJsonReport(), this.log);
                OSAUtils.writeJsonToFile("cxSCAPackages.json", scaResults.getPackages(), this.config.getReportsDir(), this.config.getOsaGenerateJsonReport(), this.log);
                OSAUtils.writeJsonToFile("cxSCASummary.json", scaResults.getSummary(), this.config.getReportsDir(), this.config.getOsaGenerateJsonReport(), this.log);
            }
            if (this.config.isGenerateScaReport()) {
                String reportFormat = this.config.getScaReportFormat();
                this.log.info("Generating SCA report. Report type: " + reportFormat);
                byte[] scanReport = this.getReport(scaResults.getScanId(), reportFormat);
                scaResults.setPDFReport(scanReport);
                String now = new SimpleDateFormat("dd_MM_yyyy-HH_mm_ss").format(new Date());
                String PDF_REPORT_NAME = "AstScaReport";
                String fileName = "";
                if (reportFormat.equalsIgnoreCase("CSV")) {
                    reportFormat = "zip";
                }
                fileName = PDF_REPORT_NAME + "_" + now + "." + reportFormat.toLowerCase();
                String pdfLink = SASTUtils.writePDFReport(scanReport, this.config.getReportsDir(), fileName, this.log, reportFormat);
                if (reportFormat.toLowerCase().equals("pdf")) {
                    scaResults.setScaPDFLink(pdfLink);
                    scaResults.setPdfFileName(fileName);
                }
            }
            return scaResults;
        }
        catch (CxClientException e) {
            this.log.error(e.getMessage());
            AstScaResults scaResults = new AstScaResults();
            scaResults.setException(e);
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
        }
        catch (ConditionTimeoutException e) {
            this.log.error(e.getMessage());
            AstScaResults scaResults = new AstScaResults();
            scaResults.setException(new CxClientException(e));
            return scaResults;
        }
        return new AstScaResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void uploadArchive(byte[] source, String uploadUrl) throws IOException {
        this.log.info("Uploading the zipped data.");
        CxHttpClient uploader = null;
        ByteArrayEntity request = new ByteArrayEntity(source);
        try {
            uploader = this.createHttpClient(uploadUrl);
            uploader.putRequest("", "", (HttpEntity)request, JsonNode.class, 200, "upload ZIP file");
        }
        finally {
            Optional.ofNullable(uploader).ifPresent(CxHttpClient::close);
        }
    }

    @Override
    public Results initiateScan() {
        this.log.info("----------------------------------- Initiating {} Scan:------------------------------------", (Object)this.getScannerDisplayName());
        AstScaResults scaResults = new AstScaResults();
        this.scanId = null;
        this.projectId = null;
        try {
            boolean isManifestAndFingerprintsOnly;
            AstScaConfig scaConfig = this.config.getAstScaConfig();
            SourceLocationType locationType = scaConfig.getSourceLocationType();
            this.projectId = this.resolveRiskManagementProject();
            boolean bl = isManifestAndFingerprintsOnly = !this.config.getAstScaConfig().isIncludeSources();
            if (isManifestAndFingerprintsOnly) {
                this.resolvingConfiguration = this.getCxSCAResolvingConfigurationForProject(this.projectId);
                this.log.info("Got the following manifest patterns {}", this.resolvingConfiguration.getManifests());
                this.log.info("Got the following fingerprint patterns {}", this.resolvingConfiguration.getFingerprints());
            }
            HttpResponse response = locationType == SourceLocationType.REMOTE_REPOSITORY ? this.submitSourcesFromRemoteRepo(scaConfig, this.projectId, scaConfig.getScaScanCustomTags()) : (scaConfig.isIncludeSources() ? this.submitAllSourcesFromLocalDir(this.projectId, this.astScaConfig.getZipFilePath()) : (scaConfig.isEnableScaResolver() ? this.submitScaResolverEvidenceFile(scaConfig) : this.submitManifestsAndFingerprintsFromLocalDir(this.projectId)));
            this.scanId = this.extractScanIdFrom(response);
            scaResults.setScanId(this.scanId);
            if (scaConfig.isEnableScaResolver() && this.tempUploadFile != null) {
                this.log.info("Deleting uploaded file for scan {}", (Object)this.tempUploadFile.getAbsolutePath());
                if (!this.tempUploadFile.delete()) {
                    this.log.error("Error while deleting uploaded file for scan {}", (Object)this.tempUploadFile.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error occurred while initiating scan.", (Throwable)e);
            this.setState(State.FAILED);
            scaResults.setException(new CxClientException("Error creating scan.", e));
        }
        return scaResults;
    }

    @Override
    protected HttpResponse submitAllSourcesFromLocalDir(String projectId, String zipFilePath) throws IOException {
        this.log.info("Using local directory flow.");
        PathFilter filter = new PathFilter(this.config.getOsaFolderExclusions(), this.config.getOsaFilterPattern(), this.log);
        String sourceDir = this.getResolvedDependencySourceDir();
        Path configFileDestination = this.copyConfigFileToSourceDir(sourceDir);
        byte[] zipFile = CxZipUtils.getZippedSources(this.config, filter, sourceDir, this.log, "astsca");
        FileUtils.deleteDirectory((File)configFileDestination.toFile());
        CxZipUtils.cleanupTempExtractedDir(this.log);
        return this.initiateScanForUpload(projectId, zipFile, this.config.getAstScaConfig(), this.config.getAstScaConfig().getScaScanCustomTags());
    }

    private HttpResponse submitScaResolverEvidenceFile(AstScaConfig scaConfig) throws IOException, CxClientException {
        File zipFile;
        this.log.info("Executing SCA Resolver flow.");
        this.log.info("Path to Sca Resolver: {}", (Object)scaConfig.getPathToScaResolver());
        String pathToResultJSONFile = "";
        String pathToSASTResultJSONFile = "";
        String pathToResultJSONFileNew = "";
        String pathToSASTResultJSONFileNew = "";
        String scaResultPathArgName = this.getScaResultPathArgumentName(scaConfig);
        if (!scaResultPathArgName.equals("")) {
            try {
                pathToResultJSONFile = this.getScaResolverResultFilePathFromAdditionalParams(scaConfig.getScaResolverAddParameters(), scaResultPathArgName);
            }
            catch (ParseException e) {
                throw new CxClientException(e.getMessage());
            }
        }
        this.log.info("SCA resolver result path configured: " + pathToResultJSONFile);
        String timeStamp = this.getTimestampFolder();
        pathToResultJSONFileNew = this.createTimestampBasedPath(pathToResultJSONFile, timeStamp, ".cxsca-results.json");
        if (this.checkSastResultPath(scaConfig)) {
            try {
                pathToSASTResultJSONFile = this.getScaResolverResultFilePathFromAdditionalParams(scaConfig.getScaResolverAddParameters(), "--sast-result-path");
            }
            catch (ParseException e) {
                throw new CxClientException(e.getMessage());
            }
            this.log.info("SAST result path location configured: " + pathToSASTResultJSONFile);
            pathToSASTResultJSONFileNew = this.createTimestampBasedPath(pathToSASTResultJSONFile, timeStamp, ".cxsca-sast-results.json");
        }
        this.log.info("Launching dependency resolution by ScaResolver. ScaResolver logs can be viewed in debug level logs of the pipeline.");
        int exitCode = SpawnScaResolver.runScaResolver(scaConfig.getPathToScaResolver(), scaConfig.getScaResolverAddParameters(), pathToResultJSONFileNew, pathToSASTResultJSONFileNew, this.log);
        if (exitCode == 0) {
            this.log.info("Dependency resolution completed.");
            String parentDir = pathToResultJSONFileNew.substring(0, pathToResultJSONFileNew.lastIndexOf(File.separator));
            String parentDirSast = "";
            File destPartentSastDir = new File("/");
            if (!StringUtils.isEmpty((CharSequence)pathToSASTResultJSONFileNew)) {
                parentDirSast = pathToSASTResultJSONFileNew.substring(0, pathToSASTResultJSONFileNew.lastIndexOf(File.separator));
                destPartentSastDir = new File(parentDirSast);
            }
            String tempDirectory = parentDir + File.separator + "tmp";
            String tempResultFile = tempDirectory + File.separator + ".cxsca-results.json";
            String tempSASTResultFile = tempDirectory + File.separator + ".cxsca-sast-results.json";
            this.log.debug("Copying ScaResolver result files to temporary location.");
            File destTempDir = new File(tempDirectory);
            File destParentDir = new File(parentDir);
            if (!destTempDir.exists()) {
                Files.createDirectory(destTempDir.toPath(), new FileAttribute[0]);
            }
            Files.copy(new File(pathToResultJSONFileNew).toPath(), new File(tempResultFile).toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (!StringUtils.isEmpty((CharSequence)pathToSASTResultJSONFileNew)) {
                Files.copy(new File(pathToSASTResultJSONFileNew).toPath(), new File(tempSASTResultFile).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.log.info("Completed File copy to " + tempDirectory);
            zipFile = this.zipEvidenceFile(destTempDir);
            if (!pathToResultJSONFileNew.equals(pathToResultJSONFile)) {
                this.log.info("Deleting directory of result file {}", (Object)destParentDir.getAbsolutePath());
                FileUtils.deleteDirectory((File)destParentDir);
                this.log.info("Deleted directory of result file " + destParentDir.getAbsolutePath());
            } else {
                this.log.info("Deleting temporary uploaded file for scan {}", (Object)destTempDir.getAbsolutePath());
                FileUtils.deleteDirectory((File)destTempDir);
                this.log.info("Deleted temp directory " + destTempDir.getAbsolutePath());
            }
            if (!StringUtils.isEmpty((CharSequence)pathToSASTResultJSONFileNew) && !pathToSASTResultJSONFileNew.equals(pathToSASTResultJSONFile)) {
                this.log.info("Deleting directory of result file {}", (Object)destPartentSastDir.getAbsolutePath());
                FileUtils.deleteDirectory((File)destPartentSastDir);
                this.log.info("Deleted directory of result file " + destPartentSastDir.getAbsolutePath());
            }
        } else {
            throw new CxClientException("Error while running sca resolver executable. Exit code: " + exitCode);
        }
        CxZipUtils.cleanupTempExtractedDir(this.log);
        return this.initiateScanForUpload(this.projectId, FileUtils.readFileToByteArray((File)zipFile), this.config.getAstScaConfig(), this.config.getAstScaConfig().getScaScanCustomTags());
    }

    public boolean checkSastResultPath(AstScaConfig scaConfig) {
        return scaConfig.getScaResolverAddParameters().contains("--sast-result-path");
    }

    private String createTimestampBasedPath(String inputResultFilePath, String timeStamp, String targetFileName) {
        if (inputResultFilePath.isEmpty()) {
            return inputResultFilePath;
        }
        String lastPathComponent = "";
        if (!inputResultFilePath.endsWith(File.separator)) {
            lastPathComponent = inputResultFilePath.substring(inputResultFilePath.lastIndexOf(File.separator) + 1, inputResultFilePath.length());
        }
        if (inputResultFilePath.endsWith(File.separator) || lastPathComponent.indexOf(".") == -1) {
            if (!inputResultFilePath.endsWith(File.separator)) {
                inputResultFilePath = inputResultFilePath + File.separator;
            }
        } else {
            return inputResultFilePath;
        }
        inputResultFilePath = inputResultFilePath + timeStamp + File.separator + targetFileName;
        return inputResultFilePath;
    }

    private String getTimestampFolder() {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
        Date date = new Date();
        Timestamp tt = new Timestamp(System.currentTimeMillis());
        String ss = sd.format(tt);
        String res = ss.replace(".", "");
        return res;
    }

    private String getScaResultPathArgumentName(AstScaConfig scaConfig) {
        String scaResolverResultPathArgName = "";
        if (scaConfig.getScaResolverAddParameters().contains("--resolver-result-path")) {
            scaResolverResultPathArgName = "--resolver-result-path";
        } else if (scaConfig.getScaResolverAddParameters().contains("-r")) {
            scaResolverResultPathArgName = "-r";
        }
        return scaResolverResultPathArgName;
    }

    public String getScaResolverResultFilePathFromAdditionalParams(String scaResolverAddParams, String arg) throws ParseException {
        String resolverResultPath = "";
        String[] argument = scaResolverAddParams.split(" ");
        for (int i = 0; i < argument.length; ++i) {
            if (!arg.equals(argument[i])) continue;
            if (argument.length - 1 == i) {
                resolverResultPath = argument[i];
                break;
            }
            resolverResultPath = argument[i + 1];
            break;
        }
        return resolverResultPath;
    }

    private HttpResponse submitManifestsAndFingerprintsFromLocalDir(String projectId) throws IOException {
        this.log.info("Using manifest only and fingerprint flow");
        String sourceDir = this.getResolvedDependencySourceDir();
        Path configFileDestination = this.copyConfigFileToSourceDir(sourceDir);
        String additinalFilters = this.getAdditionalManifestFilters();
        String finalFilters = additinalFilters + this.getManifestsIncludePattern();
        PathFilter userFilter = new PathFilter(this.config.getOsaFolderExclusions(), this.config.getOsaFilterPattern(), this.log);
        if (ArrayUtils.isNotEmpty((Object[])userFilter.getIncludes()) && !ArrayUtils.contains((Object[])userFilter.getIncludes(), (Object)"**")) {
            userFilter.addToIncludes("**");
        }
        HashSet<String> scannedFileSet = new HashSet<String>(Arrays.asList(CxSCAFileSystemUtils.scanAndGetIncludedFiles(sourceDir, userFilter)));
        PathFilter manifestIncludeFilter = new PathFilter(null, finalFilters, this.log);
        if (manifestIncludeFilter.getIncludes().length == 0) {
            throw new CxClientException(String.format("Using manifest only mode requires include filter. Resolving config does not have include patterns defined: %s", this.getManifestsIncludePattern()));
        }
        List<String> filesToZip = Arrays.stream(CxSCAFileSystemUtils.scanAndGetIncludedFiles(sourceDir, manifestIncludeFilter)).filter(scannedFileSet::contains).collect(Collectors.toList());
        List<String> filesToFingerprint = Arrays.stream(CxSCAFileSystemUtils.scanAndGetIncludedFiles(sourceDir, new PathFilter(null, this.getFingerprintsIncludePattern(), this.log))).filter(scannedFileSet::contains).collect(Collectors.toList());
        CxSCAScanFingerprints fingerprints = this.fingerprintCollector.collectFingerprints(sourceDir, filesToFingerprint);
        this.config.setZipFile(null);
        File zipFile = this.zipDirectoryAndFingerprints(sourceDir, filesToZip, fingerprints);
        this.optionallyWriteFingerprintsToFile(fingerprints);
        FileUtils.deleteDirectory((File)configFileDestination.toFile());
        CxZipUtils.cleanupTempExtractedDir(this.log);
        return this.initiateScanForUpload(projectId, FileUtils.readFileToByteArray((File)zipFile), this.astScaConfig, this.config.getAstScaConfig().getScaScanCustomTags());
    }

    private String getResolvedDependencySourceDir() throws IOException {
        String effectiveDir = this.config.getEffectiveSourceDirForDependencyScan();
        if (effectiveDir == null) {
            effectiveDir = this.config.getZipFile().getAbsolutePath();
        }
        this.log.debug("Effective Dir: {}", (Object)effectiveDir);
        if (CxZipUtils.isZip(effectiveDir, this.log)) {
            try {
                effectiveDir = CxZipUtils.extractZipToTempDirectory(effectiveDir, this.log, "astsca");
            }
            catch (IOException e) {
                this.log.error("Failed to extract ZIP file: {}", (Object)this.config.getZipFile().getAbsolutePath(), (Object)e);
                throw new IOException("Error extracting ZIP file for scanning", e);
            }
        }
        return effectiveDir;
    }

    private File zipEvidenceFile(File filePath) throws IOException {
        this.tempUploadFile = File.createTempFile("ScaResolverResults", ".zip");
        String sourceDir = filePath.getAbsolutePath();
        this.log.info("Collecting files to zip archive: {}", (Object)this.tempUploadFile.getAbsolutePath());
        long maxZipSizeBytes = this.config.getMaxZipSize() != null ? (long)(this.config.getMaxZipSize() * 1024 * 1024) : 0x80000000L;
        List<String> paths = Arrays.asList(filePath.list());
        NewCxZipFile zipper = new NewCxZipFile(this.tempUploadFile, maxZipSizeBytes, this.log);
        try {
            zipper.addMultipleFilesToArchive(new File(sourceDir), paths);
            this.log.info("Added {} files to zip.", (Object)zipper.getFileCount());
            this.log.info("The sources were zipped to {}", (Object)this.tempUploadFile.getAbsolutePath());
            File file = this.tempUploadFile;
            zipper.close();
            return file;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipper.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Zipper.MaxZipSizeReached e) {
                throw this.handleFileDeletion(filePath, new IOException("Reached maximum upload size limit of " + FileUtils.byteCountToDisplaySize((long)maxZipSizeBytes)));
            }
            catch (IOException ioException) {
                throw this.handleFileDeletion(filePath, ioException);
            }
        }
    }

    private String getAdditionalManifestFilters() {
        List<String> configFilePaths = this.config.getAstScaConfig().getConfigFilePaths();
        String additionalFilters = "";
        if (configFilePaths != null) {
            for (String configFileString : configFilePaths) {
                if (!StringUtils.isNotEmpty((CharSequence)configFileString)) continue;
                if (configFileString.lastIndexOf("\\") != -1) {
                    configFileString = configFileString.substring(configFileString.lastIndexOf("\\") + 1);
                }
                additionalFilters = additionalFilters.concat("**/" + configFileString + ",");
            }
        }
        return additionalFilters;
    }

    private Path copyConfigFileToSourceDir(String sourceDir) throws IOException {
        Path configFileDestination = Paths.get("", new String[0]);
        this.log.info("Source Directory : {}", (Object)sourceDir);
        List<String> configFilePaths = this.config.getAstScaConfig().getConfigFilePaths();
        if (configFilePaths != null) {
            for (String configFileString : configFilePaths) {
                String fileSystemSeparator;
                Path configFilePath;
                if (!StringUtils.isNotEmpty((CharSequence)configFileString) || (configFilePath = CxSCAFileSystemUtils.checkIfFileExists(sourceDir, configFileString, fileSystemSeparator = FileSystems.getDefault().getSeparator(), this.log)) == null) continue;
                configFileDestination = Paths.get(sourceDir, fileSystemSeparator, SCA_CONFIG_FOLDER_NAME);
                if (Files.notExists(configFileDestination, new LinkOption[0])) {
                    Path destDir = Files.createDirectory(configFileDestination, new FileAttribute[0]);
                    Files.copy(configFilePath, destDir.resolve(configFilePath.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Path r = configFileDestination.resolve(configFilePath.getFileName());
                    Files.copy(configFilePath, r, StandardCopyOption.REPLACE_EXISTING);
                }
                this.log.info("Config file ({}) copied to directory: {}", (Object)configFilePath, (Object)configFileDestination);
            }
        }
        return configFileDestination;
    }

    private File zipDirectoryAndFingerprints(String sourceDir, List<String> paths, CxSCAScanFingerprints fingerprints) throws IOException {
        File result = this.config.getZipFile();
        if (result != null) {
            return result;
        }
        File tempFile = this.getZipFile();
        this.log.debug("Collecting files to zip archive: {}", (Object)tempFile.getAbsolutePath());
        long maxZipSizeBytes = this.config.getMaxZipSize() != null ? (long)(this.config.getMaxZipSize() * 1024 * 1024) : 0x80000000L;
        NewCxZipFile zipper = new NewCxZipFile(tempFile, maxZipSizeBytes, this.log);
        try {
            zipper.addMultipleFilesToArchive(new File(sourceDir), paths);
            if (zipper.getFileCount() == 0L && fingerprints.getFingerprints().isEmpty()) {
                throw this.handleFileDeletion(tempFile);
            }
            if (!fingerprints.getFingerprints().isEmpty()) {
                zipper.zipContentAsFile(FINGERPRINT_FILE_NAME, FingerprintCollector.getFingerprintsAsJsonString(fingerprints).getBytes());
            } else {
                this.log.debug("No supported fingerprints found to zip");
            }
            this.log.debug("The sources were zipped to {}", (Object)tempFile.getAbsolutePath());
            File file = tempFile;
            zipper.close();
            return file;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipper.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Zipper.MaxZipSizeReached e) {
                throw this.handleFileDeletion(tempFile, new IOException("Reached maximum upload size limit of " + FileUtils.byteCountToDisplaySize((long)maxZipSizeBytes)));
            }
            catch (IOException ioException) {
                throw this.handleFileDeletion(tempFile, ioException);
            }
        }
    }

    private CxClientException handleFileDeletion(File file, IOException ioException) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            return new CxClientException(e);
        }
        return new CxClientException(ioException);
    }

    private CxClientException handleFileDeletion(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            return new CxClientException(e);
        }
        return new CxClientException("No files found to zip and no supported fingerprints found");
    }

    private String getFingerprintsIncludePattern() {
        if (StringUtils.isNotEmpty((CharSequence)this.astScaConfig.getFingerprintsIncludePattern())) {
            return this.astScaConfig.getFingerprintsIncludePattern();
        }
        return this.resolvingConfiguration.getFingerprintsIncludePattern();
    }

    private String getManifestsIncludePattern() {
        if (StringUtils.isNotEmpty((CharSequence)this.astScaConfig.getManifestsIncludePattern())) {
            return this.astScaConfig.getManifestsIncludePattern();
        }
        return this.resolvingConfiguration.getManifestsIncludePattern();
    }

    private File getZipFile() throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)this.astScaConfig.getZipFilePath())) {
            return new File(this.astScaConfig.getZipFilePath());
        }
        return File.createTempFile("zippedSource", ".bin");
    }

    private void optionallyWriteFingerprintsToFile(CxSCAScanFingerprints fingerprints) {
        if (StringUtils.isNotEmpty((CharSequence)this.astScaConfig.getFingerprintFilePath())) {
            try {
                this.fingerprintCollector.writeScanFingerprintsFile(fingerprints, this.astScaConfig.getFingerprintFilePath());
            }
            catch (IOException ioException) {
                this.log.error(String.format("Failed writing fingerprint file to %s", this.astScaConfig.getFingerprintFilePath()), (Throwable)ioException);
            }
        }
    }

    @Override
    public Results getLatestScanResults() {
        AstScaResults result = new AstScaResults();
        try {
            this.log.info("Getting latest scan results.");
            this.projectId = this.getRiskManagementProjectId(this.config.getProjectName());
            this.scanId = this.getLatestScanId(this.projectId);
            result = this.tryGetScanResults().orElse(null);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            result.setException(new CxClientException("Error getting latest scan results.", e));
        }
        return result;
    }

    private Optional<AstScaResults> tryGetScanResults() {
        AstScaResults result = null;
        if (StringUtils.isNotEmpty((CharSequence)this.scanId)) {
            result = this.getScanResults();
        } else {
            this.log.info("Unable to get scan results");
        }
        return Optional.ofNullable(result);
    }

    private String getLatestScanId(String projectId) throws IOException {
        String result = null;
        if (StringUtils.isNotEmpty((CharSequence)projectId)) {
            this.log.debug("Getting latest scan ID for project ID: {}", (Object)projectId);
            String path = String.format(LATEST_SCAN, URLEncoder.encode(projectId, ENCODING));
            JsonNode response = (JsonNode)this.httpClient.getRequest(path, "application/json", ArrayNode.class, 200, "scan ID by project ID", false);
            result = Optional.ofNullable(response).map(resp -> resp.at("/0/riskReportId").textValue()).orElse(null);
        }
        String message = result == null ? "Scan not found" : String.format("Scan ID: %s", result);
        this.log.info(message);
        return result;
    }

    private void printWebReportLink(AstScaResults scaResult) {
        if (!StringUtils.isEmpty((CharSequence)scaResult.getWebReportLink())) {
            this.log.info("{} scan results location: {}", (Object)this.getScannerDisplayName(), (Object)scaResult.getWebReportLink());
        }
    }

    void testConnection() throws IOException {
        this.login();
        this.getRiskManagementProjects();
    }

    public void login() throws IOException {
        this.log.info("Logging into {}", (Object)this.getScannerDisplayName());
        AstScaConfig scaConfig = this.config.getAstScaConfig();
        String acUrl = scaConfig.getAccessControlUrl();
        LoginSettings settings = LoginSettings.builder().accessControlBaseUrl(UrlUtils.parseURLToString(acUrl, "identity/connect/token")).username(scaConfig.getUsername()).password(scaConfig.getPassword()).tenant(scaConfig.getTenant()).build();
        ClientTypeResolver resolver = new ClientTypeResolver(this.config);
        ClientType clientType = resolver.determineClientType(acUrl);
        settings.setClientTypeForPasswordAuth(clientType);
        this.httpClient.login(settings);
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public void testScaConnection() {
        try {
            this.testConnection();
        }
        catch (IOException e) {
            throw new CxClientException(e);
        }
    }

    private String resolveRiskManagementProject() throws IOException {
        String projectName = this.config.getProjectName();
        String assignedTeam = this.config.getAstScaConfig().getTeamPath();
        String assignedTeamId = this.config.getAstScaConfig().getTeamId();
        String projectCustomTag = this.config.getAstScaConfig().getScaProjectCustomTags();
        if (!StringUtils.isEmpty((CharSequence)assignedTeamId)) {
            assignedTeam = this.getTeamById(assignedTeamId);
        } else if (StringUtils.isEmpty((CharSequence)assignedTeam)) {
            assignedTeam = this.config.getTeamPath();
        }
        this.log.info("Getting project by name: '{}'", (Object)projectName);
        String resolvedProjectId = this.getRiskManagementProjectId(projectName);
        if (resolvedProjectId == null) {
            this.log.info("Project not found, creating a new one.");
            resolvedProjectId = this.createRiskManagementProject(projectName, assignedTeam, projectCustomTag);
            this.log.info("Created a project with ID {}", (Object)resolvedProjectId);
        } else {
            this.log.info("Project already exists with ID {}", (Object)resolvedProjectId);
            this.UpdateRiskManagementProject(resolvedProjectId, projectCustomTag, assignedTeam);
        }
        return resolvedProjectId;
    }

    private String getRiskManagementProjectId(String projectName) throws IOException {
        this.log.info("Getting project ID by name: '{}'", (Object)projectName);
        if (StringUtils.isEmpty((CharSequence)projectName)) {
            throw new CxClientException("Non-empty project name must be provided.");
        }
        Project project = this.sendGetProjectRequest(projectName);
        String result = Optional.ofNullable(project).map(Project::getId).orElse(null);
        String message = result == null ? "Project not found" : String.format("Project ID: %s", result);
        this.log.info(message);
        return result;
    }

    private String getTeamById(String teamId) throws IOException {
        this.log.info("Getting Team name by ID : '{}'", (Object)teamId);
        if (StringUtils.isEmpty((CharSequence)teamId)) {
            throw new CxClientException("Team Id provided is empty.");
        }
        Team team = this.sendGetTeamById(teamId);
        String result = Optional.ofNullable(team).map(Team::getFullName).orElse(null);
        String message = result == null ? "Team not found" : String.format("Team  name: %s", result);
        this.log.info(message);
        return result;
    }

    private Project sendGetProjectRequest(String projectName) throws IOException {
        Project result;
        try {
            String getProjectByName = String.format("%s?name=%s", PROJECTS, URLEncoder.encode(projectName, ENCODING));
            result = this.httpClient.getRequest(getProjectByName, "application/json", Project.class, 200, "CxSCA project ID by name", false);
        }
        catch (CxHTTPClientException e) {
            if (e.getStatusCode() == 404) {
                result = null;
            }
            throw e;
        }
        return result;
    }

    private Team sendGetTeamById(String teamId) throws IOException {
        Team result;
        try {
            String teamNameAPI = String.format("%s/%s", TEAMBYID, teamId);
            result = this.httpClient.getRequest(this.astScaConfig.getAccessControlUrl() + "/", teamNameAPI, "application/json", "application/json", Team.class, 200, "CxSCA team ID by name", false);
        }
        catch (CxHTTPClientException e) {
            if (e.getStatusCode() == 404) {
                result = null;
            }
            throw e;
        }
        return result;
    }

    private void getRiskManagementProjects() throws IOException {
        this.httpClient.getRequest(PROJECTS, "application/json", Project.class, 200, "CxSCA projects", true);
    }

    private String createRiskManagementProject(String name, String assignedTeam, String projectCustomTag) throws IOException {
        CreateProjectRequest request = new CreateProjectRequest();
        request.setName(name);
        if (!StringUtils.isEmpty((CharSequence)assignedTeam)) {
            request.addAssignedTeams(assignedTeam);
            this.log.info("Team name: {}", (Object)assignedTeam);
        }
        this.log.info("Project level custom tag name: {}", (Object)projectCustomTag);
        if (!StringUtils.isEmpty((CharSequence)projectCustomTag)) {
            Map<String, String> tagMaps = this.customFieldMap(projectCustomTag);
            this.log.debug("Project level custom tags: {}", tagMaps);
            request.setTags(tagMaps);
        }
        StringEntity entity = HttpClientHelper.convertToStringEntity(request);
        Project newProject = this.httpClient.postRequest(PROJECTS, "application/json", (HttpEntity)entity, Project.class, 201, "create a project");
        return newProject.getId();
    }

    private void UpdateRiskManagementProject(String projectId, String customTags, String assignedTeam) throws IOException {
        Map<String, String> tagMaps;
        Project existingProject = this.httpClient.getRequest(PROJECTID.replace("id", projectId), "application/json", Project.class, 200, "got project details", false);
        UpdateProjectRequest request = new UpdateProjectRequest();
        request.setName(existingProject.getName());
        if (!StringUtils.isEmpty((CharSequence)assignedTeam)) {
            request.addAssignedTeams(assignedTeam);
            this.log.info("Team name: {}", (Object)assignedTeam);
        }
        this.log.info("Project level custom tag name: {}", (Object)customTags);
        if (existingProject.getTags() != null) {
            tagMaps = (Map<String, String>)existingProject.getTags();
            if (!StringUtils.isEmpty((CharSequence)customTags)) {
                StringTokenizer tokenizer = new StringTokenizer(customTags, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    String[] keyValue = token.split(":");
                    tagMaps.put(keyValue[0], keyValue[1]);
                }
            }
            request.setTags(tagMaps);
        } else if (!StringUtils.isEmpty((CharSequence)customTags)) {
            tagMaps = this.customFieldMap(customTags);
            request.setTags(tagMaps);
        }
        StringEntity entity = HttpClientHelper.convertToStringEntity(request);
        this.httpClient.putRequest(PROJECTID.replace("id", projectId), "application/json", (HttpEntity)entity, Project.class, 204, "Updated project successfully");
    }

    private Map<String, String> customFieldMap(String projectCustomField) {
        LinkedHashMap<String, String> customFieldMap = new LinkedHashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)projectCustomField)) {
            StringTokenizer tokenizer = new StringTokenizer(projectCustomField, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String[] keyValue = token.split(":");
                customFieldMap.put(keyValue[0], keyValue[1]);
            }
        }
        return customFieldMap;
    }

    private AstScaResults getScanResults() {
        AstScaResults result;
        this.log.debug("Getting results for scan ID {}", (Object)this.scanId);
        try {
            result = new AstScaResults();
            result.setScanId(this.scanId);
            this.reportId = this.getReportId(this.scanId);
            result.setReportId(this.reportId);
            AstScaSummaryResults scanSummary = this.getSummaryReport(this.scanId);
            result.setSummary(scanSummary);
            this.printSummary(scanSummary, this.scanId);
            List<Finding> findings = this.getFindings(this.scanId);
            result.setFindings(findings);
            List<Package> packages = this.getPackages(this.scanId);
            result.setPackages(packages);
            if (this.config.isEnablePolicyViolationsSCA()) {
                List<PolicyEvaluation> policyEvaluations = this.getPolicyEvaluation(this.reportId);
                result.setPolicyEvaluations(policyEvaluations);
                this.printPolicyEvaluations(policyEvaluations);
                this.determinePolicyViolations(result);
            }
            String reportLink = this.getWebReportLink(this.config.getAstScaConfig().getWebAppUrl());
            result.setWebReportLink(reportLink);
            this.printWebReportLink(result);
            result.setScaResultReady(true);
            this.log.info("Retrieved SCA results successfully.");
        }
        catch (IOException e) {
            throw new CxClientException("Error retrieving CxSCA scan results.", e);
        }
        return result;
    }

    @Override
    protected String getWebReportPath() throws UnsupportedEncodingException {
        return String.format(WEB_REPORT, URLEncoder.encode(this.projectId, ENCODING), URLEncoder.encode(this.scanId, ENCODING));
    }

    private AstScaSummaryResults getSummaryReport(String scanId) throws IOException {
        this.log.debug("Getting summary report.");
        String path = String.format(SUMMARY_REPORT, URLEncoder.encode(scanId, ENCODING));
        return this.httpClient.getRequest(path, "application/json", AstScaSummaryResults.class, 200, "CxSCA report summary", false);
    }

    private List<Finding> getFindings(String scanId) throws IOException {
        this.log.debug("Getting findings.");
        String path = String.format(FINDINGS, URLEncoder.encode(scanId, ENCODING));
        ArrayNode responseJson = this.httpClient.getRequest(path, "application/json", ArrayNode.class, 200, "CxSCA findings", false);
        Finding[] findings = (Finding[])caseInsensitiveObjectMapper.treeToValue((TreeNode)responseJson, Finding[].class);
        return Arrays.asList(findings);
    }

    private List<Package> getPackages(String scanId) throws IOException {
        this.log.debug("Getting packages.");
        String path = String.format(PACKAGES, URLEncoder.encode(scanId, ENCODING));
        return (List)((Object)this.httpClient.getRequest(path, "application/json", Package.class, 200, "CxSCA findings", true));
    }

    public String getReportId(String scanId) throws IOException {
        this.log.debug("Getting report id.");
        String path = String.format(REPORTID_API, URLEncoder.encode(scanId, ENCODING));
        String resultReportId = this.httpClient.getRequest(path, "application/json", String.class, 200, "CxSCA Risk ReportId", false);
        return StringUtils.strip((String)resultReportId, (String)"\"");
    }

    public List<PolicyEvaluation> getPolicyEvaluation(String reportId) throws IOException {
        this.log.debug("Getting policy evaluation for the scan report id {}.", (Object)reportId);
        String path = String.format(POLICY_MANAGEMENT_EVALUATION_API, URLEncoder.encode(reportId, ENCODING));
        return (List)((Object)this.httpClient.getRequest(path, "application/json", PolicyEvaluation.class, 200, "CxSCA policy evaulation", true));
    }

    private void determinePolicyViolations(AstScaResults result) {
        result.getPolicyEvaluations().forEach(p -> {
            if (p.getIsViolated()) {
                result.setPolicyViolated(true);
                if (p.getActions().isBreakBuild()) {
                    result.setBreakTheBuild(true);
                }
            }
        });
    }

    private void printSummary(AstScaSummaryResults summary, String scanId) {
        if (this.log.isInfoEnabled()) {
            this.log.info("----CxSCA risk report summary----");
            this.log.info("Created on: {}", (Object)summary.getCreatedOn());
            this.log.info("Direct packages: {}", (Object)summary.getDirectPackages());
            this.log.info("Critical vulnerabilities: {}", (Object)summary.getCriticalVulnerabilityCount());
            this.log.info("High vulnerabilities: {}", (Object)summary.getHighVulnerabilityCount());
            this.log.info("Medium vulnerabilities: {}", (Object)summary.getMediumVulnerabilityCount());
            this.log.info("Low vulnerabilities: {}", (Object)summary.getLowVulnerabilityCount());
            this.log.info("Scan ID: {}", (Object)scanId);
            this.log.info(String.format("Risk score: %.2f", summary.getRiskScore()));
            this.log.info("Total packages: {}", (Object)summary.getTotalPackages());
            this.log.info("Total outdated packages: {}", (Object)summary.getTotalOutdatedPackages());
        }
    }

    private void printPolicyEvaluations(List<PolicyEvaluation> policyEvaulations) {
        if (this.log.isInfoEnabled()) {
            this.log.info("----CxSCA Policy Evaluation Results----");
            policyEvaulations.forEach(p -> this.printPolicyEvaluation((PolicyEvaluation)p));
            this.log.info("---------------------------------------");
        }
    }

    private void printPolicyEvaluation(PolicyEvaluation p) {
        if (this.log.isInfoEnabled()) {
            this.log.info("  Policy name: {} | Violated:{} | Policy Description: {}", new Object[]{p.getName(), p.getIsViolated(), p.getDescription()});
            p.getRules().forEach(r -> this.log.info("    Rule name: {} | Violated: {}", (Object)r.getName(), (Object)r.getIsViolated()));
        }
    }

    private void validate(AstScaConfig config) {
        String error = null;
        if (config == null) {
            error = "%s config must be provided.";
        } else if (StringUtils.isEmpty((CharSequence)config.getApiUrl())) {
            error = "%s API URL must be provided.";
        } else if (StringUtils.isEmpty((CharSequence)config.getAccessControlUrl())) {
            error = "%s access control URL must be provided.";
        } else {
            RemoteRepositoryInfo repoInfo = config.getRemoteRepositoryInfo();
            if (repoInfo == null && config.getSourceLocationType() == SourceLocationType.REMOTE_REPOSITORY) {
                error = "%s remote repository info must be provided.";
            } else if (repoInfo != null && StringUtils.isNotEmpty((CharSequence)repoInfo.getBranch())) {
                error = "%s doesn't support specifying custom branches. It currently uses the default branch of a repo.";
            }
        }
        if (error != null) {
            throw new IllegalArgumentException(String.format(error, this.getScannerDisplayName()));
        }
    }
}

