/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.ast;

import com.cx.restclient.ast.AstClient;
import com.cx.restclient.ast.dto.common.ASTConfig;
import com.cx.restclient.ast.dto.common.HandlerRef;
import com.cx.restclient.ast.dto.common.RemoteRepositoryInfo;
import com.cx.restclient.ast.dto.common.ScanConfig;
import com.cx.restclient.ast.dto.sast.AstSastConfig;
import com.cx.restclient.ast.dto.sast.AstSastResults;
import com.cx.restclient.ast.dto.sast.SastScanConfigValue;
import com.cx.restclient.ast.dto.sast.report.AstSastSummaryResults;
import com.cx.restclient.ast.dto.sast.report.Finding;
import com.cx.restclient.ast.dto.sast.report.QueryDescription;
import com.cx.restclient.ast.dto.sast.report.ScanResultsResponse;
import com.cx.restclient.ast.dto.sast.report.SeverityCounter;
import com.cx.restclient.ast.dto.sast.report.SingleScanSummary;
import com.cx.restclient.ast.dto.sast.report.SummaryResponse;
import com.cx.restclient.common.Scanner;
import com.cx.restclient.common.UrlUtils;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.LoginSettings;
import com.cx.restclient.dto.PathFilter;
import com.cx.restclient.dto.Results;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.dto.SourceLocationType;
import com.cx.restclient.dto.scansummary.Severity;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.exception.CxHTTPClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import com.cx.restclient.osa.dto.ClientType;
import com.cx.restclient.sast.utils.State;
import com.cx.restclient.sast.utils.zip.CxZipUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;

public class AstSastClient
extends AstClient
implements Scanner {
    private static final String ENGINE_TYPE_FOR_API = "sast";
    private static final String REF_TYPE_BRANCH = "branch";
    private static final String SUMMARY_PATH = properties.get("astSast.scanSummary");
    private static final String SCAN_RESULTS_PATH = properties.get("astSast.scanResults");
    private static final String AUTH_PATH = properties.get("astSast.authentication");
    private static final String WEB_PROJECT_PATH = properties.get("astSast.webProject");
    private static final String URL_PARSING_EXCEPTION = "URL parsing exception.";
    private static final String DESCRIPTIONS_PATH = properties.get("astSast.descriptionPath");
    private static final int DEFAULT_PAGE_SIZE = 1000;
    private static final int NO_FINDINGS_CODE = 4004;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String API_VERSION = "*/*; version=0.1";
    private static final String SCAN_ID_PARAM_NAME = "scan-id";
    private static final String OFFSET_PARAM_NAME = "offset";
    private static final String LIMIT_PARAM_NAME = "limit";
    private static final String ID_PARAM_NAME = "ids";
    private static final int URL_MAX_CHAR_SIZE = 1490;
    private String scanId;

    public AstSastClient(CxScanConfig config, Logger log) {
        super(config, log);
        AstSastConfig astConfig = this.config.getAstSastConfig();
        this.validate(astConfig);
        String normalizedUrl = StringUtils.stripEnd((String)astConfig.getApiUrl(), (String)"/");
        this.httpClient = this.createHttpClient(normalizedUrl);
        this.httpClient.addCustomHeader("Accept", API_VERSION);
    }

    @Override
    public Results init() {
        this.log.debug("Initializing {} client.", (Object)this.getScannerDisplayName());
        AstSastResults astResults = new AstSastResults();
        try {
            ClientType clientType = this.getClientType();
            LoginSettings settings = this.getLoginSettings(clientType);
            this.httpClient.login(settings);
        }
        catch (Exception e) {
            super.handleInitError(e, astResults);
        }
        return astResults;
    }

    private LoginSettings getLoginSettings(ClientType clientType) throws MalformedURLException {
        String authUrl = UrlUtils.parseURLToString(this.config.getAstSastConfig().getApiUrl(), AUTH_PATH);
        return LoginSettings.builder().accessControlBaseUrl(authUrl).clientTypeForPasswordAuth(clientType).build();
    }

    private ClientType getClientType() {
        AstSastConfig astConfig = this.config.getAstSastConfig();
        return ClientType.builder().clientId(astConfig.getClientId()).clientSecret(astConfig.getClientSecret()).scopes("ast-api").grantType("client_credentials").build();
    }

    @Override
    protected String getScannerDisplayName() {
        return ScannerType.AST_SAST.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void uploadArchive(byte[] source, String uploadUrl) throws IOException {
        this.log.info("Uploading the zipped data.");
        ByteArrayEntity request = new ByteArrayEntity(source);
        String baseAstUri = this.httpClient.getRootUri();
        this.httpClient.setRootUri(uploadUrl);
        try {
            this.httpClient.putRequest("", "", (HttpEntity)request, JsonNode.class, 200, "upload ZIP file");
        }
        finally {
            this.httpClient.setRootUri(baseAstUri);
        }
    }

    @Override
    public Results initiateScan() {
        this.log.info("----------------------------------- Initiating {} Scan:------------------------------------", (Object)this.getScannerDisplayName());
        AstSastResults astResults = new AstSastResults();
        this.scanId = null;
        AstSastConfig astConfig = this.config.getAstSastConfig();
        try {
            SourceLocationType locationType = astConfig.getSourceLocationType();
            HttpResponse response = locationType == SourceLocationType.REMOTE_REPOSITORY ? this.submitSourcesFromRemoteRepo(astConfig, this.config.getProjectName(), this.config.getAstScaConfig().getScaScanCustomTags()) : this.submitAllSourcesFromLocalDir(this.config.getProjectName(), astConfig.getZipFilePath());
            this.scanId = this.extractScanIdFrom(response);
            astResults.setScanId(this.scanId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            this.setState(State.FAILED);
            astResults.setException(new CxClientException("Error creating scan.", e));
        }
        return astResults;
    }

    @Override
    protected HttpResponse submitAllSourcesFromLocalDir(String projectId, String zipFilePath) throws IOException {
        this.log.info("Using local directory flow.");
        PathFilter filter = new PathFilter("", "", this.log);
        String sourceDir = this.config.getSourceDir();
        byte[] zipFile = CxZipUtils.getZippedSources(this.config, filter, sourceDir, this.log, "astsast");
        return this.initiateScanForUpload(projectId, zipFile, this.config.getAstSastConfig(), this.config.getAstScaConfig().getScaScanCustomTags());
    }

    @Override
    protected ScanConfig getScanConfig() {
        String presetName = this.config.getAstSastConfig().getPresetName();
        if (StringUtils.isEmpty((CharSequence)presetName)) {
            throw new CxClientException("Scan preset must be specified.");
        }
        String isIncremental = Boolean.toString(this.config.getAstSastConfig().isIncremental());
        SastScanConfigValue configValue = SastScanConfigValue.builder().incremental(isIncremental).presetName(presetName).build();
        return ScanConfig.builder().type(ENGINE_TYPE_FOR_API).value(configValue).build();
    }

    @Override
    protected HandlerRef getBranchToScan(RemoteRepositoryInfo repoInfo) {
        return HandlerRef.builder().type(REF_TYPE_BRANCH).value(repoInfo.getBranch()).build();
    }

    @Override
    public Results waitForScanResults() {
        AstSastResults result;
        try {
            this.waitForScanToFinish(this.scanId);
            result = this.retrieveScanResults();
        }
        catch (CxClientException e) {
            this.log.error(e.getMessage());
            result = new AstSastResults();
            result.setException(e);
        }
        return result;
    }

    private AstSastResults retrieveScanResults() {
        try {
            AstSastResults result = new AstSastResults();
            result.setScanId(this.scanId);
            AstSastSummaryResults scanSummary = this.getSummary();
            result.setSummary(scanSummary);
            List<Finding> findings = this.getFindings();
            result.setFindings(findings);
            String projectLink = this.getWebReportLink(this.config.getAstSastConfig().getWebAppUrl());
            result.setWebReportLink(projectLink);
            return result;
        }
        catch (IOException e) {
            String message = String.format("Error getting %s scan results.", this.getScannerDisplayName());
            throw new CxClientException(message, e);
        }
    }

    @Override
    protected String getWebReportPath() throws UnsupportedEncodingException {
        return String.format(WEB_PROJECT_PATH, URLEncoder.encode(this.config.getProjectName(), ENCODING));
    }

    private AstSastSummaryResults getSummary() {
        AstSastSummaryResults result = new AstSastSummaryResults();
        String summaryUrl = this.getRelativeSummaryUrl();
        SummaryResponse summaryResponse = this.getSummaryResponse(summaryUrl);
        SingleScanSummary nativeSummary = AstSastClient.getNativeSummary(summaryResponse);
        AstSastClient.setFindingCountsPerSeverity(nativeSummary.getSeverityCounters(), result);
        result.setStatusCounters(nativeSummary.getStatusCounters());
        result.setTotalCounter(nativeSummary.getTotalCounter());
        return result;
    }

    private List<Finding> getFindings() throws IOException {
        ScanResultsResponse response;
        List<Finding> findingsFromResponse;
        int offset = 0;
        int limit = this.config.getAstSastConfig().getResultsPageSize();
        if (limit <= 0) {
            limit = 1000;
        }
        ArrayList<Finding> allFindings = new ArrayList<Finding>();
        do {
            String relativeUrl = this.getRelativeResultsUrl(offset, limit);
            response = this.getScanResultsResponse(relativeUrl);
            findingsFromResponse = response.getResults();
            allFindings.addAll(findingsFromResponse);
        } while ((offset += findingsFromResponse.size()) < response.getTotalCount());
        this.log.info(String.format("Total findings: %d", allFindings.size()));
        try {
            this.populateAdditionalFields(allFindings);
        }
        catch (CxClientException e) {
            this.log.error(e.getMessage());
        }
        return allFindings;
    }

    private void populateAdditionalFields(List<Finding> allFindings) throws IOException {
        HashMap<String, QueryDescription> allQueryDescriptionMap = new HashMap<String, QueryDescription>();
        Set<String> queryIDs = allFindings.stream().map(finding -> finding.getQueryID()).collect(Collectors.toSet());
        while (queryIDs.size() > 0) {
            HashSet<String> processedQueryIds = new HashSet<String>();
            List<QueryDescription> queryDescriptionList = this.processQueryIDs(queryIDs, processedQueryIds);
            allQueryDescriptionMap.putAll(queryDescriptionList.stream().collect(Collectors.toMap(QueryDescription::getQueryId, queryDescription -> queryDescription)));
            queryIDs.removeAll(processedQueryIds);
        }
        this.log.info(String.format("QueryIds with descriptions size: {} ", allQueryDescriptionMap.size()));
        allFindings.stream().forEach(finding -> {
            String queryId = finding.getQueryID();
            QueryDescription query = (QueryDescription)allQueryDescriptionMap.get(queryId);
            finding.setDescription(query.getResultDescription());
        });
    }

    private String prepareURL(Set<String> ids, Set<String> processedIds) {
        try {
            int lengthOtherParams = new URIBuilder().setPath(DESCRIPTIONS_PATH).setParameter(SCAN_ID_PARAM_NAME, this.scanId).build().toString().length();
            URIBuilder uriBuilder = new URIBuilder();
            uriBuilder.setPath(DESCRIPTIONS_PATH);
            int idsAllowedLength = 1490 - lengthOtherParams;
            LinkedList<BasicNameValuePair> nameValues = new LinkedList<BasicNameValuePair>();
            for (String id : ids) {
                if ((idsAllowedLength = idsAllowedLength - ID_PARAM_NAME.length() - 2 - id.length()) <= 0) continue;
                processedIds.add(id);
                nameValues.add(new BasicNameValuePair(ID_PARAM_NAME, id));
            }
            uriBuilder.setParameters(nameValues);
            String result = uriBuilder.setParameter(SCAN_ID_PARAM_NAME, this.scanId).build().toString();
            this.log.debug(String.format("Getting descriptions from %s", result));
            return result;
        }
        catch (URISyntaxException e) {
            throw new CxClientException(URL_PARSING_EXCEPTION, e);
        }
    }

    private String getRelativeResultsUrl(int offset, int limit) {
        try {
            String result = new URIBuilder().setPath(SCAN_RESULTS_PATH).setParameter(SCAN_ID_PARAM_NAME, this.scanId).setParameter(OFFSET_PARAM_NAME, Integer.toString(offset)).setParameter(LIMIT_PARAM_NAME, Integer.toString(limit)).build().toString();
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Getting findings from %s", result));
            }
            return result;
        }
        catch (URISyntaxException e) {
            throw new CxClientException(URL_PARSING_EXCEPTION, e);
        }
    }

    private List<QueryDescription> processQueryIDs(Set<String> ids, Set<String> processedIds) throws IOException {
        String relativeUrl = this.prepareURL(ids, processedIds);
        List result = (List)((Object)this.httpClient.getRequest(relativeUrl, "application/json", QueryDescription.class, 200, "retrieving queries description", true));
        return result;
    }

    private ScanResultsResponse getScanResultsResponse(String relativeUrl) throws IOException {
        return this.httpClient.getRequest(relativeUrl, "application/json", ScanResultsResponse.class, 200, "retrieving scan results", false);
    }

    private SummaryResponse getSummaryResponse(String relativeUrl) {
        SummaryResponse result;
        try {
            result = this.httpClient.getRequest(relativeUrl, "application/json", SummaryResponse.class, 200, "retrieving scan summary", false);
        }
        catch (Exception e) {
            result = this.getEmptySummaryIfApplicable(e);
        }
        return result;
    }

    private SummaryResponse getEmptySummaryIfApplicable(Exception e) {
        if (!this.noFindingsWereDetected(e)) {
            throw new CxClientException("Error getting scan summary.", e);
        }
        SummaryResponse result = new SummaryResponse();
        result.getScansSummaries().add(new SingleScanSummary());
        return result;
    }

    private boolean noFindingsWereDetected(Exception e) {
        CxHTTPClientException httpException;
        boolean result = false;
        if (e instanceof CxHTTPClientException && (httpException = (CxHTTPClientException)e).getStatusCode() == 404 && StringUtils.isNotEmpty((CharSequence)httpException.getResponseBody())) {
            try {
                JsonNode body = objectMapper.readTree(httpException.getResponseBody());
                result = body.get("code").asInt() == 4004;
            }
            catch (Exception parsingException) {
                this.log.warn("Error parsing the 'Not found' response.", (Throwable)parsingException);
            }
        }
        return result;
    }

    private String getRelativeSummaryUrl() {
        try {
            String result = new URIBuilder().setPath(SUMMARY_PATH).setParameter("scan-ids", this.scanId).build().toString();
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Getting summary from %s", result));
            }
            return result;
        }
        catch (URISyntaxException e) {
            throw new CxClientException(URL_PARSING_EXCEPTION, e);
        }
    }

    private static void setFindingCountsPerSeverity(List<SeverityCounter> nativeCounters, AstSastSummaryResults target) {
        if (nativeCounters == null) {
            return;
        }
        for (SeverityCounter counter : nativeCounters) {
            Severity parsedSeverity = (Severity)EnumUtils.getEnum(Severity.class, (String)counter.getSeverity());
            int value = counter.getCounter();
            if (parsedSeverity == null) continue;
            if (parsedSeverity == Severity.CRITICAL) {
                target.setCriticalVulnerabilityCount(value);
                continue;
            }
            if (parsedSeverity == Severity.HIGH) {
                target.setHighVulnerabilityCount(value);
                continue;
            }
            if (parsedSeverity == Severity.MEDIUM) {
                target.setMediumVulnerabilityCount(value);
                continue;
            }
            if (parsedSeverity != Severity.LOW) continue;
            target.setLowVulnerabilityCount(value);
        }
    }

    private static SingleScanSummary getNativeSummary(SummaryResponse summaryResponse) {
        return Optional.ofNullable(summaryResponse).map(SummaryResponse::getScansSummaries).filter(scanSummaries -> scanSummaries.size() == 1).map(scanSummaries -> (SingleScanSummary)scanSummaries.get(0)).orElseThrow(() -> new CxClientException("Invalid summary response."));
    }

    @Override
    public Results getLatestScanResults() {
        this.log.error("Unsupported Operation.");
        AstSastResults result = new AstSastResults();
        result.setException(new CxClientException(new UnsupportedOperationException()));
        return result;
    }

    @Override
    public void close() {
        Optional.ofNullable(this.httpClient).ifPresent(CxHttpClient::close);
    }

    private void validate(ASTConfig astSastConfig) {
        this.log.debug("Validating config.");
        String error = null;
        if (astSastConfig == null) {
            error = "%s config must be provided.";
        } else if (StringUtils.isBlank((CharSequence)astSastConfig.getApiUrl())) {
            error = "%s API URL must be provided.";
        }
        if (error != null) {
            throw new IllegalArgumentException(String.format(error, this.getScannerDisplayName()));
        }
    }
}

