/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.ast;

import com.cx.restclient.ast.AstWaiter;
import com.cx.restclient.ast.dto.common.ASTConfig;
import com.cx.restclient.ast.dto.common.GitCredentials;
import com.cx.restclient.ast.dto.common.HandlerRef;
import com.cx.restclient.ast.dto.common.ProjectToScan;
import com.cx.restclient.ast.dto.common.RemoteRepositoryInfo;
import com.cx.restclient.ast.dto.common.ScanConfig;
import com.cx.restclient.ast.dto.common.ScanStartHandler;
import com.cx.restclient.ast.dto.common.StartScanRequest;
import com.cx.restclient.ast.dto.sca.AstScaConfig;
import com.cx.restclient.common.UrlUtils;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.configuration.PropertyFileLoader;
import com.cx.restclient.dto.Results;
import com.cx.restclient.dto.SourceLocationType;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import com.cx.restclient.httpClient.utils.HttpClientHelper;
import com.cx.restclient.sast.utils.State;
import com.cx.restclient.sca.dto.CxSCAScanAPIConfig;
import com.cx.restclient.sca.dto.CxSCAScanApiConfigEntry;
import com.cx.restclient.sca.dto.GetUploadUrlRequest;
import com.cx.restclient.sca.dto.ScanAPIConfigEntry;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;

public abstract class AstClient {
    private static final String LOCATION_HEADER = "Location";
    private static final String CREDENTIAL_TYPE_PASSWORD = "password";
    protected static final String ENCODING = StandardCharsets.UTF_8.name();
    protected final CxScanConfig config;
    protected final Logger log;
    protected CxHttpClient httpClient;
    private State state = State.SUCCESS;
    protected static final PropertyFileLoader properties = PropertyFileLoader.getDefaultInstance();
    public static final String GET_SCAN = properties.get("ast.getScan");
    public static final String CREATE_SCAN = properties.get("ast.createScan");
    public static final String GET_UPLOAD_URL = properties.get("ast.getUploadUrl");

    public AstClient(CxScanConfig config, Logger log) {
        this.validate(config, log);
        this.config = config;
        this.log = log;
    }

    protected abstract String getScannerDisplayName();

    protected abstract ScanConfig getScanConfig();

    protected abstract HandlerRef getBranchToScan(RemoteRepositoryInfo var1);

    protected abstract HttpResponse submitAllSourcesFromLocalDir(String var1, String var2) throws IOException;

    protected abstract String getWebReportPath() throws UnsupportedEncodingException;

    protected CxHttpClient createHttpClient(String baseUrl) {
        this.log.debug("Creating HTTP client.");
        CxHttpClient client = new CxHttpClient(baseUrl, this.config.getCxOrigin(), this.config.getCxOriginUrl(), this.config.isDisableCertificateValidation(), false, null, this.config.isScaProxy(), this.config.getScaProxyConfig(), this.log, this.config.getNTLM(), this.config.getPluginVersion());
        client.setTeamPathHeader("");
        return client;
    }

    private void validate(CxScanConfig config, Logger log) {
        if (config == null && log == null) {
            throw new CxClientException("Both scan config and log must be provided.");
        }
    }

    protected HttpResponse sendStartScanRequest(RemoteRepositoryInfo repoInfo, SourceLocationType sourceLocation, String projectId, String scanCustomTags) throws IOException {
        this.log.debug("Constructing the 'start scan' request");
        ScanStartHandler handler = this.getScanStartHandler(repoInfo);
        Map<String, String> scanCustomMap = this.customFiledMap(scanCustomTags);
        ProjectToScan project = ProjectToScan.builder().id(projectId).type(sourceLocation.getApiValue()).handler(handler).build();
        List<ScanConfig> apiScanConfig = Collections.singletonList(this.getScanConfig());
        StartScanRequest request = StartScanRequest.builder().project(project).config(apiScanConfig).tags(scanCustomMap).build();
        StringEntity entity = HttpClientHelper.convertToStringEntity(request);
        this.log.info("Sending the 'start scan' request.");
        return this.httpClient.postRequest(CREATE_SCAN, "application/json", (HttpEntity)entity, HttpResponse.class, 201, "start the scan");
    }

    private Map<String, String> customFiledMap(String scanCustomField) {
        HashMap<String, String> customFieldMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)scanCustomField)) {
            StringTokenizer tokenizer = new StringTokenizer(scanCustomField, ",");
            this.log.info("scan custom Tags: {}", (Object)scanCustomField);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String[] keyValue = token.split(":");
                customFieldMap.put(keyValue[0], keyValue[1]);
            }
        }
        return customFieldMap;
    }

    protected HttpResponse submitSourcesFromRemoteRepo(ASTConfig config, String projectId, String customTags) throws IOException {
        this.log.info("Using remote repository flow.");
        RemoteRepositoryInfo repoInfo = config.getRemoteRepositoryInfo();
        this.validateRepoInfo(repoInfo);
        URL sanitizedUrl = AstClient.sanitize(repoInfo.getUrl());
        this.log.info("Repository URL: {}", (Object)sanitizedUrl);
        return this.sendStartScanRequest(repoInfo, SourceLocationType.REMOTE_REPOSITORY, projectId, customTags);
    }

    protected void waitForScanToFinish(String scanId) {
        this.log.info("------------------------------------Get {} Results:-----------------------------------", (Object)this.getScannerDisplayName());
        this.log.info("Waiting for {} scan to finish", (Object)this.getScannerDisplayName());
        AstWaiter waiter = new AstWaiter(this.httpClient, this.config, this.getScannerDisplayName(), this.log);
        waiter.waitForScanToFinish(scanId);
        this.log.info("{} scan finished successfully. Retrieving {} scan results.", (Object)this.getScannerDisplayName(), (Object)this.getScannerDisplayName());
    }

    private ScanStartHandler getScanStartHandler(RemoteRepositoryInfo repoInfo) {
        this.log.debug("Creating the handler object.");
        HandlerRef ref = this.getBranchToScan(repoInfo);
        String password = StringUtils.defaultString((String)repoInfo.getPassword());
        String username = StringUtils.defaultString((String)repoInfo.getUsername());
        GitCredentials credentials = GitCredentials.builder().type(CREDENTIAL_TYPE_PASSWORD).value(password).build();
        URL effectiveRepoUrl = this.getEffectiveRepoUrl(repoInfo);
        return ScanStartHandler.builder().ref(ref).username(username).credentials(credentials).url(effectiveRepoUrl.toString()).build();
    }

    protected URL getEffectiveRepoUrl(RemoteRepositoryInfo repoInfo) {
        return repoInfo.getUrl();
    }

    protected String getWebReportLink(String baseUrl) {
        String result = null;
        String warning = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)baseUrl)) {
                String path = this.getWebReportPath();
                result = UrlUtils.parseURLToString(baseUrl, path);
            } else {
                warning = "Web app URL is not specified.";
            }
        }
        catch (MalformedURLException e) {
            warning = "Invalid web app URL.";
        }
        catch (Exception e) {
            warning = "General error.";
        }
        Optional.ofNullable(warning).ifPresent(warn -> this.log.warn("Unable to generate web report link. {}", warn));
        return result;
    }

    private static URL sanitize(URL url) throws MalformedURLException {
        return new URL(url.getProtocol(), url.getHost(), url.getFile());
    }

    private void validateRepoInfo(RemoteRepositoryInfo repoInfo) {
        this.log.debug("Validating remote repository info.");
        if (repoInfo == null) {
            String message = String.format("%s must be provided in %s configuration when using source location of type %s.", RemoteRepositoryInfo.class.getName(), this.getScannerDisplayName(), SourceLocationType.REMOTE_REPOSITORY.name());
            throw new CxClientException(message);
        }
    }

    protected String extractScanIdFrom(HttpResponse response) {
        String result = null;
        this.log.debug("Extracting scan ID from the '{}' response header.", (Object)LOCATION_HEADER);
        if (response != null && response.getLastHeader(LOCATION_HEADER) != null) {
            String urlPathWithScanId = response.getLastHeader(LOCATION_HEADER).getValue();
            result = FilenameUtils.getName((String)urlPathWithScanId);
        }
        if (!StringUtils.isNotEmpty(result)) {
            throw new CxClientException("Unable to get scan ID.");
        }
        this.log.info("Scan started successfully. Scan ID: {}", result);
        return result;
    }

    protected void handleInitError(Exception e, Results results) {
        String message = String.format("Failed to init %s client. %s", this.getScannerDisplayName(), e.getMessage());
        this.log.error(message);
        this.setState(State.FAILED);
        results.setException(new CxClientException(message, e));
    }

    protected HttpResponse initiateScanForUpload(String projectId, byte[] zipFile, ASTConfig scanConfig, String scanCustomTag) throws IOException {
        String uploadedArchiveUrl = this.getSourcesUploadUrl(scanConfig);
        String cleanPath = uploadedArchiveUrl.split("\\?")[0];
        this.log.info("Uploading to: {}", (Object)cleanPath);
        this.uploadArchive(zipFile, uploadedArchiveUrl);
        RemoteRepositoryInfo uploadedFileInfo = new RemoteRepositoryInfo();
        uploadedFileInfo.setUrl(new URL(uploadedArchiveUrl));
        return this.sendStartScanRequest(uploadedFileInfo, SourceLocationType.LOCAL_DIRECTORY, projectId, scanCustomTag);
    }

    private String getSourcesUploadUrl(ASTConfig scanConfig) throws IOException {
        JsonNode response;
        if (scanConfig instanceof AstScaConfig) {
            AstScaConfig scaConfig = (AstScaConfig)scanConfig;
            boolean includeSources = scaConfig.isIncludeSources();
            CxSCAScanAPIConfig scaApiConfig = CxSCAScanAPIConfig.builder().includeSourceCode(includeSources ? "true" : "false").build();
            CxSCAScanApiConfigEntry configentry = CxSCAScanApiConfigEntry.builder().type("sca").value(scaApiConfig).build();
            List<ScanAPIConfigEntry> scanconfigEntry = Collections.singletonList(configentry);
            GetUploadUrlRequest request = GetUploadUrlRequest.builder().config(scanconfigEntry).build();
            StringEntity entity = HttpClientHelper.convertToStringEntity(request);
            response = this.httpClient.postRequest(GET_UPLOAD_URL, null, (HttpEntity)entity, JsonNode.class, 200, "get upload URL for sources");
        } else {
            response = this.httpClient.postRequest(GET_UPLOAD_URL, null, null, JsonNode.class, 200, "get upload URL for sources");
        }
        if (response == null || response.get("url") == null) {
            throw new CxClientException("Unable to get the upload URL.");
        }
        return response.get("url").asText();
    }

    protected abstract void uploadArchive(byte[] var1, String var2) throws IOException;

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }
}

